/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.MatcherAssert;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.el.mvel.DelegateVariableResolverFactory;
import org.mule.el.mvel.GlobalVariableResolverFactory;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.el.mvel.MessageVariableResolverFactory;
import org.mule.el.mvel.StaticVariableResolverFactory;
import org.mule.el.mvel.VariableVariableResolverFactory;
import org.mule.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public abstract class AbstractVarAssignmentDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    public static final String PROPERTY_NAME = "foo";
    private final EnricherDataTypePropagator dataTypePropagator;

    protected AbstractVarAssignmentDataTypePropagatorTestCase(EnricherDataTypePropagator dataTypePropagator) {
        this.dataTypePropagator = dataTypePropagator;
    }

    protected void doAssignmentDataTypePropagationTest(PropertyScope scope, String expression) throws Exception {
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MuleEvent testEvent = AbstractVarAssignmentDataTypePropagatorTestCase.getTestEvent("Test Message");
        ParserConfiguration parserConfiguration = MVELExpressionLanguage.createParserConfiguration((Map)Collections.EMPTY_MAP);
        MVELExpressionLanguageContext context = this.createMvelExpressionLanguageContext(testEvent, parserConfiguration);
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(parserConfiguration));
        MVEL.executeExpression((Object)compiledExpression, (VariableResolverFactory)context);
        this.dataTypePropagator.propagate(testEvent.getMessage(), new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        MatcherAssert.assertThat((Object)testEvent.getMessage().getPropertyDataType(PROPERTY_NAME, scope), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    protected MVELExpressionLanguageContext createMvelExpressionLanguageContext(MuleEvent testEvent, ParserConfiguration parserConfiguration) {
        MVELExpressionLanguageContext context = new MVELExpressionLanguageContext(parserConfiguration, muleContext);
        StaticVariableResolverFactory staticContext = new StaticVariableResolverFactory(parserConfiguration, muleContext);
        GlobalVariableResolverFactory globalContext = new GlobalVariableResolverFactory(Collections.EMPTY_MAP, Collections.EMPTY_MAP, parserConfiguration, muleContext);
        context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(Collections.EMPTY_MAP, (VariableResolverFactory)new DelegateVariableResolverFactory((VariableResolverFactory)staticContext, (VariableResolverFactory)new MessageVariableResolverFactory(parserConfiguration, muleContext, testEvent.getMessage(), (VariableResolverFactory)new DelegateVariableResolverFactory((VariableResolverFactory)globalContext, (VariableResolverFactory)new VariableVariableResolverFactory(parserConfiguration, muleContext, testEvent))))));
        return context;
    }
}

