/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.expression.MessageExpressionEvaluator;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class MessageExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private static final String PAYLOAD = "test";
    private static final String PAYLOAD_EXPRESSION = "payload";

    @Test
    public void testUsingEvaluatorDirectly() throws Exception {
        MessageExpressionEvaluator eval = new MessageExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)PAYLOAD, muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Object result = eval.evaluate(null, (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)message, (Object)result);
        result = eval.evaluate(null, null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("id", (MuleMessage)message));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("correlationId", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(1), (Object)eval.evaluate("correlationSequence", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(2), (Object)eval.evaluate("correlationGroupSize", (MuleMessage)message));
        Assert.assertEquals((Object)"foo", (Object)eval.evaluate("replyTo", (MuleMessage)message));
        Assert.assertEquals((Object)e, (Object)eval.evaluate("exception", (MuleMessage)message));
        Assert.assertEquals((Object)"UTF-8", (Object)eval.evaluate("encoding", (MuleMessage)message));
        Assert.assertEquals((Object)PAYLOAD, (Object)eval.evaluate(PAYLOAD_EXPRESSION, (MuleMessage)message));
        try {
            eval.evaluate("xxx", (MuleMessage)message);
            Assert.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception e1) {
            // empty catch block
        }
    }

    @Test
    public void testUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)PAYLOAD, muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[message:id]", (MuleMessage)message));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationId]", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(1), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationSequence]", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(2), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationGroupSize]", (MuleMessage)message));
        Assert.assertEquals((Object)"foo", (Object)muleContext.getExpressionManager().evaluate("#[message:replyTo]", (MuleMessage)message));
        Assert.assertEquals((Object)e, (Object)muleContext.getExpressionManager().evaluate("#[message:exception]", (MuleMessage)message));
        Assert.assertEquals((Object)"UTF-8", (Object)muleContext.getExpressionManager().evaluate("#[message:encoding]", (MuleMessage)message));
        Assert.assertEquals((Object)PAYLOAD, (Object)muleContext.getExpressionManager().evaluate("#[message:payload]", (MuleMessage)message));
        try {
            muleContext.getExpressionManager().evaluate("#[message:xxx]", (MuleMessage)message, true);
            Assert.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void evaluatesPayloadWithType() throws Exception {
        MessageExpressionEvaluator evaluator = new MessageExpressionEvaluator();
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(CUSTOM_ENCODING);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)PAYLOAD);
        Mockito.when((Object)message.getDataType()).thenReturn((Object)dataType);
        TypedValue typedValue = evaluator.evaluateTyped(PAYLOAD_EXPRESSION, message);
        MatcherAssert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)PAYLOAD));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }
}

