/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.concurrent.Latch;

public class RegisteredObjectLifecycleTestCase
extends AbstractMuleContextTestCase {
    private static final long TIMEOUT = 1000L;
    protected Latch initLatch;
    protected Latch startLatch;
    protected Latch stopLatch;
    protected Latch disposeLatch;
    private DummyBean bean = new DummyBean();

    @Override
    protected void doSetUp() throws Exception {
        this.bean = new DummyBean();
        this.initLatch = new Latch();
        this.startLatch = new Latch();
        this.stopLatch = new Latch();
        this.disposeLatch = new Latch();
    }

    @Test
    public void testLifecycleForMuleContext() throws Exception {
        muleContext.getRegistry().registerObject("dummy", (Object)this.bean);
        Assert.assertTrue((boolean)this.initLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.start();
        Assert.assertTrue((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.stop();
        Assert.assertTrue((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.dispose();
        Assert.assertTrue((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testLifecycleForUnregisteredObject() throws Exception {
        muleContext.getRegistry().registerObject("dummy", (Object)this.bean);
        Assert.assertTrue((boolean)this.initLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.start();
        Assert.assertTrue((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.getRegistry().unregisterObject("dummy");
        Assert.assertTrue((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    public class DummyBean
    implements Lifecycle {
        public String echo(String echo) {
            return echo;
        }

        public void initialise() throws InitialisationException {
            RegisteredObjectLifecycleTestCase.this.initLatch.countDown();
        }

        public void start() throws MuleException {
            RegisteredObjectLifecycleTestCase.this.startLatch.countDown();
        }

        public void stop() throws MuleException {
            RegisteredObjectLifecycleTestCase.this.stopLatch.countDown();
        }

        public void dispose() {
            RegisteredObjectLifecycleTestCase.this.disposeLatch.countDown();
        }

        public boolean isInitialised() {
            return false;
        }

        public boolean isStarted() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }

        public boolean isDisposed() {
            return false;
        }
    }
}

