/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.DynamicRouteResolver;
import org.mule.routing.IdentifiableDynamicRouteResolver;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class AbstractDynamicRoundRobinTestCase
extends AbstractMuleContextTestCase {
    protected static final String LETTER_A = "a";
    protected static final String LETTER_B = "b";
    protected static final String LETTER_C = "c";
    protected static final String ID_1 = "ID_1";
    protected static final String ID_2 = "ID_2";
    protected static final String EXCEPTION_MESSAGE = "Failure!";
    protected static final String ID_PROPERTY_NAME = "id";

    protected List<MessageProcessor> getMessageProcessorsList() {
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        messageProcessors.add(new LetterMessageProcessor(LETTER_A));
        messageProcessors.add(new LetterMessageProcessor(LETTER_B));
        messageProcessors.add(new LetterMessageProcessor(LETTER_C));
        return messageProcessors;
    }

    protected List<MessageProcessor> getMessageProcessorsListWithFailingMessageProcessor() {
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        messageProcessors.add(new LetterMessageProcessor(LETTER_A));
        messageProcessors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new DefaultMuleException(CoreMessages.createStaticMessage((String)AbstractDynamicRoundRobinTestCase.EXCEPTION_MESSAGE));
            }
        });
        messageProcessors.add(new LetterMessageProcessor(LETTER_B));
        return messageProcessors;
    }

    protected IdentifiableDynamicRouteResolver getIdentifiableDynamicRouteResolver() {
        return new IdentifiableDynamicRouteResolver(){

            public String getRouteIdentifier(MuleEvent event) throws MessagingException {
                return (String)event.getMessage().getInvocationProperty(AbstractDynamicRoundRobinTestCase.ID_PROPERTY_NAME);
            }

            public List<MessageProcessor> resolveRoutes(MuleEvent event) throws MessagingException {
                return AbstractDynamicRoundRobinTestCase.this.getMessageProcessorsList();
            }
        };
    }

    protected DynamicRouteResolver getDynamicRouteResolver() {
        return new DynamicRouteResolver(){

            public List<MessageProcessor> resolveRoutes(MuleEvent event) throws MessagingException {
                return AbstractDynamicRoundRobinTestCase.this.getMessageProcessorsList();
            }
        };
    }

    protected MuleEvent getEvent() throws Exception {
        return MuleTestUtils.getTestEvent((Object)"Test Message", MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    protected MuleEvent getEventWithId(String id) throws Exception {
        MuleEvent event = this.getEvent();
        event.setFlowVariable(ID_PROPERTY_NAME, (Object)id);
        return event;
    }

    public static class LetterMessageProcessor
    implements MessageProcessor {
        private String letter;

        public LetterMessageProcessor(String letter) {
            this.letter = letter;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            try {
                event.getMessage().setPayload((Object)this.letter);
                return event;
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }
}

