/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractObjectSerializerContractTestCase
extends AbstractMuleContextTestCase {
    private static final String STRING_MESSAGE = "Hello World";
    protected ObjectSerializer serializer;

    @Test(expected=IllegalArgumentException.class)
    public final void nullBytes() throws Exception {
        this.serializer.deserialize((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void nullStream() throws Exception {
        this.serializer.deserialize((InputStream)null);
    }

    @Test
    public final void nullObject() throws Exception {
        byte[] bytes = this.serializer.serialize(null);
        Object object = this.serializer.deserialize(bytes);
        junit.framework.Assert.assertNull((Object)object);
    }

    @Test
    public final void inputStreamClosed() throws Exception {
        byte[] bytes = this.serializer.serialize((Object)STRING_MESSAGE);
        InputStream inputStream = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(bytes));
        String output = (String)this.serializer.deserialize(inputStream);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.equalTo((Object)STRING_MESSAGE));
    }

    @Test
    public final void serializeWithoutDefaultConstructor() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Locale locale = Locale.ITALIAN;
        DateTime dateTime = new DateTime(calendar, locale);
        dateTime.changeTimeZone("Pacific/Midway");
        MuleEvent event = AbstractObjectSerializerContractTestCase.getTestEvent(dateTime);
        byte[] bytes = this.serializer.serialize((Object)event.getMessage());
        MuleMessage message = (MuleMessage)this.serializer.deserialize(bytes);
        DateTime deserealized = (DateTime)message.getPayload();
        junit.framework.Assert.assertEquals((Object)calendar, (Object)deserealized.toCalendar());
        junit.framework.Assert.assertEquals((String)dateTime.format(), (String)deserealized.format());
    }
}

