/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.springframework.util.StringUtils;

public final class ValidationMessages
extends MessageFactory {
    private final String bundlePath;
    private final Locale locale;

    public ValidationMessages() {
        this.bundlePath = ValidationMessages.getBundlePath((String)"validation");
        this.locale = Locale.getDefault();
    }

    public ValidationMessages(String bundlePath, String locale) {
        this.bundlePath = bundlePath;
        this.locale = StringUtils.isEmpty((Object)locale) ? Locale.getDefault() : new Locale(locale);
    }

    protected ResourceBundle getBundle(String bundlePath) {
        ResourceBundle.Control control;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Loading resource bundle: " + bundlePath + " for locale " + this.locale));
        }
        ResourceBundle bundle = (control = this.getReloadControl()) != null ? ResourceBundle.getBundle(bundlePath, this.locale, this.getClassLoader(), control) : ResourceBundle.getBundle(bundlePath, this.locale, this.getClassLoader());
        return bundle;
    }

    public Message failedBooleanValidation(boolean value, boolean expected) {
        return this.createMessage(this.bundlePath, 1, expected, value);
    }

    public Message invalidNumberType(Object value, String numberType) {
        return this.createMessage(this.bundlePath, 2, value, numberType);
    }

    public Message lowerThan(Object value, Object boundary) {
        return this.createMessage(this.bundlePath, 3, value, boundary);
    }

    public Message greaterThan(Object value, Object boundary) {
        return this.createMessage(this.bundlePath, 4, value, boundary);
    }

    public Message invalidEmail(String email) {
        return this.createMessage(this.bundlePath, 5, email);
    }

    public Message invalidIp(String ip) {
        return this.createMessage(this.bundlePath, 6, ip);
    }

    public Message lowerThanMinSize(Object value, int minSize, int actualSize) {
        return this.createMessage(this.bundlePath, 7, value, minSize, actualSize);
    }

    public Message greaterThanMaxSize(Object value, int maxSize, int actualSize) {
        return this.createMessage(this.bundlePath, 8, value, maxSize, actualSize);
    }

    public Message valueIsNull() {
        return this.createMessage(this.bundlePath, 9);
    }

    public Message collectionIsEmpty() {
        return this.createMessage(this.bundlePath, 10);
    }

    public Message stringIsBlank() {
        return this.createMessage(this.bundlePath, 11);
    }

    public Message mapIsEmpty() {
        return this.createMessage(this.bundlePath, 12);
    }

    public Message valueIsBlankLiteral() {
        return this.createMessage(this.bundlePath, 13);
    }

    public Message wasExpectingNull() {
        return this.createMessage(this.bundlePath, 14);
    }

    public Message invalidTime(String time, String locale, String pattern) {
        return this.createMessage(this.bundlePath, 15, time, pattern, locale);
    }

    public Message invalidUrl(String url) {
        return this.createMessage(this.bundlePath, 16, url);
    }

    public Message regexDoesNotMatch(String value, String regex) {
        return this.createMessage(this.bundlePath, 17, value, regex);
    }

    public Message arrayIsEmpty() {
        return this.createMessage(this.bundlePath, 18);
    }

    public Message stringIsNotBlank() {
        return this.createMessage(this.bundlePath, 19);
    }

    public Message collectionIsNotEmpty() {
        return this.createMessage(this.bundlePath, 20);
    }

    public Message mapIsNotEmpty() {
        return this.createMessage(this.bundlePath, 21);
    }

    public Message arrayIsNotEmpty() {
        return this.createMessage(this.bundlePath, 22);
    }
}

