/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import com.google.common.net.InetAddresses;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.Message;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;

public class IpValidator
extends AbstractValidator {
    private final String ip;

    public IpValidator(String ip, ValidationContext validationContext) {
        super(validationContext);
        this.ip = ip;
    }

    @Override
    public ValidationResult validate(MuleEvent event) {
        return InetAddresses.isInetAddress((String)this.ip) ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected Message getDefaultErrorMessage() {
        return this.getMessages().invalidIp(this.ip);
    }
}

