/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;

public class CookieWrapper
extends NameValuePair {
    private String domain;
    private String path;
    private Object expiryDate;
    private String maxAge;
    private String secure;
    private String version;

    public void parse(MuleMessage message, ExpressionManager expressionManager) {
        this.setName(this.parse(this.getName(), message, expressionManager));
        this.setValue(this.parse(this.getValue(), message, expressionManager));
        this.domain = this.parse(this.domain, message, expressionManager);
        this.path = this.parse(this.path, message, expressionManager);
        if (this.expiryDate != null) {
            this.expiryDate = this.evaluateDate(this.expiryDate, message, expressionManager);
        }
        this.maxAge = this.parse(this.maxAge, message, expressionManager);
        this.secure = this.parse(this.secure, message, expressionManager);
        this.version = this.parse(this.version, message, expressionManager);
    }

    private String parse(String value, MuleMessage message, ExpressionManager expressionManager) {
        if (value != null) {
            return expressionManager.parse(value, message);
        }
        return value;
    }

    private Object evaluateDate(Object date, MuleMessage message, ExpressionManager expressionManager) {
        if (date != null && date instanceof String && expressionManager.isExpression(date.toString())) {
            return expressionManager.evaluate(date.toString(), message);
        }
        return date;
    }

    public Cookie createCookie() throws ParseException {
        Cookie cookie = new Cookie();
        cookie.setName(this.getName());
        cookie.setValue(this.getValue());
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        if (this.expiryDate != null) {
            cookie.setExpiryDate(this.formatExpiryDate(this.expiryDate));
        }
        if (this.maxAge != null && this.expiryDate == null) {
            cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)Integer.valueOf(this.maxAge).intValue() * 1000L));
        }
        if (this.secure != null) {
            cookie.setSecure(Boolean.valueOf(this.secure).booleanValue());
        }
        if (this.version != null) {
            cookie.setVersion(Integer.valueOf(this.version).intValue());
        }
        return cookie;
    }

    private Date formatExpiryDate(Object expiryDate) throws ParseException {
        if (expiryDate instanceof String) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format.parse((String)expiryDate);
        }
        return (Date)expiryDate;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setExpiryDate(Object expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

