/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.module.db.internal.domain.connection.AbstractConnectionFactory;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.connection.RetryConnectionFactory;
import org.mule.module.db.internal.domain.connection.SimpleConnectionFactory;
import org.mule.module.db.internal.domain.connection.TransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.database.ConfigurableDbConfigFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.GenericDbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionCoordinationDbTransactionManager;
import org.mule.module.db.internal.domain.type.CompositeDbTypeManager;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.MetadataDbTypeManager;
import org.mule.module.db.internal.domain.type.StaticDbTypeManager;

public class GenericDbConfigFactory
implements ConfigurableDbConfigFactory {
    private List<DbType> customDataTypes;
    private RetryPolicyTemplate retryPolicyTemplate;

    @Override
    public DbConfig create(String name, DataSource dataSource) {
        AbstractConnectionFactory connectionFactory = this.retryPolicyTemplate == null ? new SimpleConnectionFactory() : new RetryConnectionFactory(this.retryPolicyTemplate, new SimpleConnectionFactory());
        DbTypeManager dbTypeManager = this.doCreateTypeManager();
        TransactionalDbConnectionFactory dbConnectionFactory = new TransactionalDbConnectionFactory(new TransactionCoordinationDbTransactionManager(), dbTypeManager, connectionFactory, dataSource);
        return this.doCreateDbConfig(dataSource, dbTypeManager, dbConnectionFactory, name);
    }

    protected DbConfig doCreateDbConfig(DataSource datasource, DbTypeManager dbTypeManager, DbConnectionFactory dbConnectionFactory, String name) {
        return new GenericDbConfig(datasource, name, dbTypeManager, dbConnectionFactory);
    }

    protected DbTypeManager doCreateTypeManager() {
        List<DbType> vendorDataTypes;
        ArrayList<DbTypeManager> typeManagers = new ArrayList<DbTypeManager>();
        typeManagers.add(new MetadataDbTypeManager());
        if (this.customDataTypes.size() > 0) {
            typeManagers.add(new StaticDbTypeManager(this.customDataTypes));
        }
        if ((vendorDataTypes = this.getVendorDataTypes()).size() > 0) {
            typeManagers.add(new StaticDbTypeManager(vendorDataTypes));
        }
        typeManagers.add(new StaticDbTypeManager(JdbcTypes.types));
        return new CompositeDbTypeManager(typeManagers);
    }

    protected List<DbType> getVendorDataTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setCustomDataTypes(List<DbType> customDataTypes) {
        this.customDataTypes = customDataTypes;
    }

    @Override
    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }
}

