/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.declaration.ConfigurationConstruct;
import org.mule.extension.introspection.declaration.Construct;
import org.mule.extension.introspection.declaration.DeclarationConstruct;
import org.mule.extension.introspection.declaration.HasCapabilities;
import org.mule.extension.introspection.declaration.HasParameters;
import org.mule.extension.introspection.declaration.OperationConstruct;
import org.mule.extension.introspection.declaration.ParameterDeclaration;
import org.mule.extension.introspection.declaration.WithParameters;

public class ParameterConstruct<T extends ParameterConstruct>
implements Construct,
HasCapabilities<ParameterConstruct<T>> {
    private final DeclarationConstruct declaration;
    private final ParameterDeclaration parameter;
    private final HasParameters owner;

    ParameterConstruct(HasParameters owner, ParameterDeclaration parameter, DeclarationConstruct declaration) {
        this.declaration = declaration;
        this.owner = owner;
        this.parameter = parameter;
    }

    public T ofType(Class<?> type, Class<?> ... parametrizedTypes) {
        return this.ofType(DataType.of(type, parametrizedTypes));
    }

    public T ofType(DataType dataType) {
        this.parameter.setType(dataType);
        return (T)this;
    }

    public T describedAs(String description) {
        this.parameter.setDescription(description);
        return (T)this;
    }

    public T whichIsNotDynamic() {
        this.parameter.setDynamic(false);
        return (T)this;
    }

    public T whichIsDynamic() {
        this.parameter.setDynamic(true);
        return (T)this;
    }

    public ConfigurationConstruct withConfig(String name) {
        return this.getRootConstruct().withConfig(name);
    }

    public OperationConstruct withOperation(String name) {
        return this.getRootConstruct().withOperation(name);
    }

    public WithParameters with() {
        return new WithParameters(this.owner, this.getRootConstruct());
    }

    @Override
    public DeclarationConstruct getRootConstruct() {
        return this.declaration;
    }

    @Override
    public ParameterConstruct<T> withCapability(Object capability) {
        this.parameter.addCapability(capability);
        return this;
    }

    public ParameterDeclaration getDeclaration() {
        return this.parameter;
    }
}

