/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.HttpMessageBuilder;
import org.mule.module.http.internal.HttpParamType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.module.http.internal.multipart.HttpMultipartEncoder;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.DataTypeUtils;
import org.mule.util.IOUtils;
import org.mule.util.NumberUtils;
import org.mule.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseBuilder
extends HttpMessageBuilder
implements Initialisable,
MuleContextAware {
    public static final String MULTIPART = "multipart";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String statusCode;
    private String reasonPhrase;
    private boolean disablePropertiesAsHeaders = false;
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private boolean multipartEntityWithNoMultipartContentyTypeWarned;
    private boolean mapPayloadButNoUrlEncodedContentyTypeWarned;
    private AttributeEvaluator statusCodeEvaluator;
    private AttributeEvaluator reasonPhraseEvaluator;
    private MuleContext muleContext;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.init();
    }

    void init() throws InitialisationException {
        this.statusCodeEvaluator = new AttributeEvaluator(this.statusCode).initialize(this.muleContext.getExpressionManager());
        this.reasonPhraseEvaluator = new AttributeEvaluator(this.reasonPhrase).initialize(this.muleContext.getExpressionManager());
    }

    public HttpResponse build(org.mule.module.http.internal.domain.response.HttpResponseBuilder httpResponseBuilder, MuleEvent event) throws MessagingException {
        HttpEntity httpEntity;
        DataType dataType;
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder();
        Set outboundProperties = event.getMessage().getOutboundPropertyNames();
        if (!this.disablePropertiesAsHeaders) {
            for (String outboundPropertyName : outboundProperties) {
                if (outboundPropertyName.startsWith("http.")) continue;
                Object outboundPropertyValue = event.getMessage().getOutboundProperty(outboundPropertyName);
                httpResponseHeaderBuilder.addHeader(outboundPropertyName, outboundPropertyValue);
            }
        }
        if (!outboundProperties.contains("Content-Type") && !"*/*".equals((dataType = event.getMessage().getDataType()).getMimeType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", DataTypeUtils.getContentType((DataType)dataType));
        }
        ParameterMap resolvedHeaders = this.resolveParams(event, HttpParamType.HEADER);
        for (String name : resolvedHeaders.keySet()) {
            List<String> paramValues = resolvedHeaders.getAll(name);
            for (String value : paramValues) {
                httpResponseHeaderBuilder.addHeader(name, value);
            }
        }
        String configuredContentType = httpResponseHeaderBuilder.getContentType();
        String existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding();
        String existingContentLength = httpResponseHeaderBuilder.getContentLength();
        if (!event.getMessage().getOutboundAttachmentNames().isEmpty()) {
            if (configuredContentType == null) {
                httpResponseHeaderBuilder.addContentType(this.createMultipartFormDataContentType());
            } else if (!configuredContentType.startsWith(MULTIPART)) {
                this.warnNoMultipartContentTypeButMultipartEntity(httpResponseHeaderBuilder.getContentType());
            }
            httpEntity = this.createMultipartEntity(event, httpResponseHeaderBuilder.getContentType());
        } else {
            ByteArrayHttpEntity byteArrayHttpEntity;
            Object payload = event.getMessage().getPayload();
            if (payload == NullPayload.getInstance()) {
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
                httpEntity = new EmptyHttpEntity();
            } else if (payload instanceof Map) {
                if (configuredContentType == null) {
                    httpResponseHeaderBuilder.addContentType("application/x-www-form-urlencoded");
                } else if (!configuredContentType.startsWith("application/x-www-form-urlencoded")) {
                    this.warnMapPayloadButNoUrlEncodedContentType(httpResponseHeaderBuilder.getContentType());
                }
                httpEntity = this.createUrlEncodedEntity(event, (Map)payload);
            } else if (payload instanceof InputStream) {
                if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null) {
                    this.setupChunkedEncoding(httpResponseHeaderBuilder);
                    httpEntity = new InputStreamHttpEntity((InputStream)payload);
                } else {
                    byteArrayHttpEntity = new ByteArrayHttpEntity(IOUtils.toByteArray((InputStream)((InputStream)payload)));
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                    httpEntity = byteArrayHttpEntity;
                }
            } else {
                try {
                    byteArrayHttpEntity = new ByteArrayHttpEntity(event.getMessage().getPayloadAsBytes());
                    if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && "chunked".equals(existingTransferEncoding)) {
                        this.setupChunkedEncoding(httpResponseHeaderBuilder);
                    } else {
                        this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                    }
                    httpEntity = byteArrayHttpEntity;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Collection<String> headerNames = httpResponseHeaderBuilder.getHeaderNames();
        for (String headerName : headerNames) {
            Collection<String> values = httpResponseHeaderBuilder.getHeader(headerName);
            for (String value : values) {
                httpResponseBuilder.addHeader(headerName, value);
            }
        }
        Integer resolvedStatusCode = this.resolveStatusCode(event);
        if (resolvedStatusCode != null) {
            httpResponseBuilder.setStatusCode(resolvedStatusCode);
        }
        if (this.reasonPhrase != null) {
            httpResponseBuilder.setReasonPhrase(this.reasonPhraseEvaluator.resolveStringValue(event));
        }
        httpResponseBuilder.setEntity(httpEntity);
        return httpResponseBuilder.build();
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, int contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
        }
        httpResponseHeaderBuilder.addContentLenght(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        httpResponseHeaderBuilder.addHeader("Transfer-Encoding", "chunked");
    }

    private Integer resolveStatusCode(MuleEvent event) {
        if (this.statusCode != null) {
            return this.statusCodeEvaluator.resolveIntegerValue(event);
        }
        Object statusCodeOutboundProperty = event.getMessage().getOutboundProperty("http.status");
        if (statusCodeOutboundProperty != null) {
            return NumberUtils.toInt((Object)statusCodeOutboundProperty);
        }
        return null;
    }

    private String createMultipartFormDataContentType() {
        return String.format("%s; boundary=%s", "multipart/form-data", UUID.getUUID());
    }

    private HttpEntity createUrlEncodedEntity(MuleEvent event, Map payload) {
        Map mapPayload = payload;
        HttpEntity entity = new EmptyHttpEntity();
        if (!mapPayload.isEmpty()) {
            String encodedBody = mapPayload instanceof ParameterMap ? HttpParser.encodeString(event.getEncoding(), ((ParameterMap)mapPayload).toListValuesMap()) : HttpParser.encodeString(event.getEncoding(), mapPayload);
            entity = new ByteArrayHttpEntity(encodedBody.getBytes());
        }
        return entity;
    }

    private void warnMapPayloadButNoUrlEncodedContentType(String contentType) {
        if (!this.mapPayloadButNoUrlEncodedContentyTypeWarned) {
            this.logger.warn(String.format("Payload is a Map which will be used to generate an url encoded http body but Contenty-Type specified is %s and not %s", contentType, "application/x-www-form-urlencoded"));
            this.mapPayloadButNoUrlEncodedContentyTypeWarned = true;
        }
    }

    private void warnNoMultipartContentTypeButMultipartEntity(String contentType) {
        if (!this.multipartEntityWithNoMultipartContentyTypeWarned) {
            this.logger.warn(String.format("Sending http response with Content-Type %s but the message has attachment and a multipart entity is generated", contentType));
            this.multipartEntityWithNoMultipartContentyTypeWarned = true;
        }
    }

    private HttpEntity createMultipartEntity(MuleEvent event, String contentType) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message contains outbound attachments. Ignoring payload and trying to generate multipart response");
        }
        HashMap<String, DataHandler> parts = new HashMap<String, DataHandler>();
        for (String outboundAttachmentName : event.getMessage().getOutboundAttachmentNames()) {
            parts.put(outboundAttachmentName, event.getMessage().getOutboundAttachment(outboundAttachmentName));
        }
        try {
            MultipartHttpEntity multipartEntity = new MultipartHttpEntity(HttpPartDataSource.createFrom(parts));
            return new ByteArrayHttpEntity(HttpMultipartEncoder.createMultipartContent(multipartEntity, contentType));
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    public static HttpResponseBuilder emptyInstance(MuleContext muleContext) throws InitialisationException {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder();
        httpResponseBuilder.setMuleContext(muleContext);
        httpResponseBuilder.init();
        return httpResponseBuilder;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setDisablePropertiesAsHeaders(boolean disablePropertiesAsHeaders) {
        this.disablePropertiesAsHeaders = disablePropertiesAsHeaders;
    }

    public void setResponseStreaming(HttpStreamingType responseStreaming) {
        this.responseStreaming = responseStreaming;
    }

    public HttpStreamingType getResponseStreaming() {
        return this.responseStreaming;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

