/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.DataTypeUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class HttpResponseToMuleEvent {
    private static final String MULTI_PART_PREFIX = "multipart/";
    private DefaultHttpRequester requester;
    private MuleContext muleContext;
    private AttributeEvaluator parseResponse;

    public HttpResponseToMuleEvent(DefaultHttpRequester requester, MuleContext muleContext, AttributeEvaluator parseResponse) {
        this.requester = requester;
        this.muleContext = muleContext;
        this.parseResponse = parseResponse;
    }

    public void convert(MuleEvent muleEvent, HttpResponse response) throws MessagingException {
        String responseContentType = response.getHeaderValue("Content-Type".toLowerCase());
        DataType dataType = muleEvent.getMessage().getDataType();
        if (StringUtils.isEmpty((String)responseContentType) && !"*/*".equals(dataType.getMimeType())) {
            responseContentType = DataTypeUtils.getContentType((DataType)dataType);
        }
        InputStream responseInputStream = ((InputStreamHttpEntity)response.getEntity()).getInputStream();
        String encoding = this.getEncoding(responseContentType);
        Map<String, Object> inboundProperties = this.getInboundProperties(response);
        Map<String, DataHandler> inboundAttachments = null;
        Object payload = responseInputStream;
        if (responseContentType != null && this.parseResponse.resolveBooleanValue(muleEvent).booleanValue()) {
            if (responseContentType.startsWith(MULTI_PART_PREFIX)) {
                try {
                    inboundAttachments = this.getInboundAttachments(responseInputStream, responseContentType);
                    payload = NullPayload.getInstance();
                }
                catch (IOException e) {
                    throw new MessagingException(muleEvent, (Throwable)e);
                }
            } else if (responseContentType.startsWith("application/x-www-form-urlencoded".toLowerCase())) {
                payload = HttpParser.decodeString(IOUtils.toString((InputStream)responseInputStream), encoding);
            }
        }
        DefaultMuleMessage message = new DefaultMuleMessage(muleEvent.getMessage().getPayload(), inboundProperties, null, inboundAttachments, this.muleContext, muleEvent.getMessage().getDataType());
        if (encoding != null) {
            message.setEncoding(encoding);
        }
        muleEvent.setMessage((MuleMessage)message);
        this.setResponsePayload(payload, muleEvent);
    }

    private String getEncoding(String responseContentType) {
        MediaType mediaType;
        String encoding = Charset.defaultCharset().name();
        if (responseContentType != null && (mediaType = MediaType.parse((String)responseContentType)).charset().isPresent()) {
            encoding = ((Charset)mediaType.charset().get()).name();
        }
        return encoding;
    }

    private Map<String, Object> getInboundProperties(HttpResponse response) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String headerName : response.getHeaderNames()) {
            properties.put(headerName, response.getHeaderValue(headerName));
        }
        properties.put("http.status", response.getStatusCode());
        properties.put("http.reason", response.getReasonPhrase());
        return properties;
    }

    private Map<String, DataHandler> getInboundAttachments(InputStream responseInputStream, String responseContentType) throws IOException {
        Collection<HttpPartDataSource> httpParts = HttpPartDataSource.createFrom(HttpParser.parseMultipartContent(responseInputStream, responseContentType));
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        for (HttpPartDataSource httpPart : httpParts) {
            attachments.put(httpPart.getName(), new DataHandler((DataSource)httpPart));
        }
        return attachments;
    }

    private void setResponsePayload(Object payload, MuleEvent muleEvent) {
        if (StringUtils.isEmpty((String)this.requester.getTarget()) || "#[payload]".equals(this.requester.getTarget())) {
            muleEvent.getMessage().setPayload(payload);
        } else {
            this.muleContext.getExpressionManager().enrich(this.requester.getTarget(), muleEvent, payload);
        }
    }
}

