/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Date;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.CustomJob;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.CustomJobFromMessageConfig;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;

public class QuartzMessageDispatcher
extends AbstractMessageDispatcher {
    public QuartzMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        JobConfig jobConfig = (JobConfig)this.endpoint.getProperty((Object)"jobConfig");
        if (jobConfig == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"jobConfig").getMessage());
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("jobDynamic", (Object)Boolean.TRUE);
        MuleMessage msg = event.getMessage();
        for (String key : msg.getInvocationPropertyNames()) {
            jobDataMap.put(key, msg.getInvocationProperty(key));
        }
        for (String key : msg.getOutboundPropertyNames()) {
            jobDataMap.put(key, msg.getOutboundProperty(key));
        }
        if (jobConfig instanceof ScheduledDispatchJobConfig) {
            ScheduledDispatchJobConfig scheduledDispatchJobConfig = (ScheduledDispatchJobConfig)jobConfig;
            String endpointRef = event.getMuleContext().getExpressionManager().parse(scheduledDispatchJobConfig.getEndpointRef(), event);
            jobDataMap.put("endpointRef", endpointRef);
        }
        Job job = null;
        Object payload = event.getMessage().getPayload();
        if (jobConfig instanceof CustomJobConfig) {
            job = ((CustomJobConfig)jobConfig).getJob();
        } else if (jobConfig instanceof CustomJobFromMessageConfig) {
            job = ((CustomJobFromMessageConfig)jobConfig).getJob(msg);
            jobConfig = ((CustomJobFromMessageConfig)jobConfig).getJobConfig(msg);
        }
        jobDataMap.put("jobConfig", (Object)jobConfig);
        Class<? extends Job> jobClass = jobConfig.getJobClass();
        if (job != null) {
            jobDataMap.put("jobObject", (Object)job);
            jobClass = CustomJob.class;
        }
        jobDataMap.put("payload", payload);
        String cronExpression = jobDataMap.getString("cronExpression");
        String repeatInterval = jobDataMap.getString("repeatInterval");
        String repeatCount = jobDataMap.getString("repeatCount");
        String startDelay = jobDataMap.getString("startDelay");
        String groupName = jobConfig.getGroupName();
        String jobGroupName = jobConfig.getJobGroupName();
        if (groupName == null) {
            groupName = "mule";
        }
        if (jobGroupName == null) {
            jobGroupName = groupName;
        }
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(this.endpoint.getEndpointURI().getAddress() + "-" + event.getId(), groupName).usingJobData(jobDataMap).build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.endpoint.getEndpointURI().toString() + "-" + event.getId(), groupName).forJob(jobDetail.getKey().getName(), jobGroupName);
        if (cronExpression != null) {
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
        } else if (repeatInterval != null) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(Long.parseLong(repeatInterval)).withRepeatCount(repeatCount != null ? Integer.parseInt(repeatCount) : -1));
        } else {
            throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
        }
        Scheduler scheduler = ((QuartzConnector)this.getConnector()).getQuartzScheduler();
        long start = System.currentTimeMillis();
        if (startDelay != null) {
            start += Long.parseLong(startDelay);
        }
        triggerBuilder.startAt(new Date(start));
        scheduler.scheduleJob(jobDetail, triggerBuilder.build());
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getEndpoint().getMuleContext());
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

