/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.mule.DefaultMuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;

public class UdpMuleMessageFactory
extends AbstractMuleMessageFactory {
    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{DatagramPacket.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        DatagramPacket packet = (DatagramPacket)transportMessage;
        int length = packet.getLength();
        byte[] payload = new byte[length];
        System.arraycopy(packet.getData(), 0, payload, 0, length);
        return payload;
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        DatagramPacket packet = (DatagramPacket)transportMessage;
        this.addAddressProperty(message, packet);
        this.addPortProperty(message, packet);
    }

    private void addAddressProperty(DefaultMuleMessage message, DatagramPacket packet) {
        InetAddress address = packet.getAddress();
        if (address != null) {
            message.setInboundProperty("packet.address", (Object)address);
        }
    }

    private void addPortProperty(DefaultMuleMessage message, DatagramPacket packet) {
        Integer port = packet.getPort();
        message.setInboundProperty("packet.port", (Object)port);
    }
}

