/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;

public class ServletResponseWriter {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private MuleMessageToHttpResponse responseTransformer = new MuleMessageToHttpResponse();
    private String defaultContentType = "text/plain";
    private boolean feedbackOnEmptyResponse;

    public void writeResponse(HttpServletResponse servletResponse, MuleMessage message, Map<String, String> httpHeaders) throws Exception {
        this.addHeaders(servletResponse, httpHeaders);
        this.writeResponseFromMessage(servletResponse, message);
        servletResponse.flushBuffer();
    }

    public void writeEmptyResponse(HttpServletResponse servletResponse, Map<String, String> httpHeaders) throws IOException {
        this.addHeaders(servletResponse, httpHeaders);
        servletResponse.setStatus(204);
        if (this.feedbackOnEmptyResponse) {
            servletResponse.setStatus(200);
            servletResponse.getWriter().write("Action was processed successfully. There was no result");
        }
        servletResponse.flushBuffer();
    }

    public void writeErrorResponse(HttpServletResponse servletResponse, MuleMessage message, int errorCode, String errorMessage, Map<String, String> httpHeaders) throws Exception {
        this.addHeaders(servletResponse, httpHeaders);
        HttpResponse httpResponse = this.convertToHttpResponse(message);
        this.setHttpHeadersOnServletResponse(httpResponse, servletResponse);
        servletResponse.sendError(errorCode, errorMessage);
    }

    public void writeErrorResponse(HttpServletResponse servletResponse, int errorCode, String errorMessage, Map<String, String> httpHeaders) throws Exception {
        this.addHeaders(servletResponse, httpHeaders);
        servletResponse.sendError(errorCode, errorMessage);
    }

    public void writeNonHtmlErrorResponse(HttpServletResponse servletResponse, int errorCode, String errorMessage, Map<String, String> httpHeaders) throws Exception {
        this.addHeaders(servletResponse, httpHeaders);
        servletResponse.setStatus(errorCode);
        servletResponse.getOutputStream().write(errorMessage.getBytes());
        servletResponse.flushBuffer();
    }

    private void writeResponseFromMessage(HttpServletResponse servletResponse, MuleMessage message) throws Exception {
        HttpResponse httpResponse = this.convertToHttpResponse(message);
        this.setHttpHeadersOnServletResponse(httpResponse, servletResponse);
        if (!servletResponse.isCommitted()) {
            servletResponse.setStatus(httpResponse.getStatusCode());
        }
        if (httpResponse.hasBody()) {
            OutputHandler outputHandler = httpResponse.getBody();
            outputHandler.write(RequestContext.getEvent(), (OutputStream)servletResponse.getOutputStream());
        }
    }

    private HttpResponse convertToHttpResponse(MuleMessage message) throws TransformerException {
        if (message.getPayload() instanceof HttpResponse) {
            return (HttpResponse)message.getPayload();
        }
        return (HttpResponse)this.responseTransformer.transform((Object)message);
    }

    private void addHeaders(HttpServletResponse servletResponse, Map<String, String> httpHeaders) {
        if (httpHeaders != null) {
            for (String httpHeaderKey : httpHeaders.keySet()) {
                servletResponse.addHeader(httpHeaderKey, httpHeaders.get(httpHeaderKey));
            }
        }
    }

    private HttpServletResponse setHttpHeadersOnServletResponse(HttpResponse httpResponse, HttpServletResponse servletResponse) {
        Header[] headers;
        httpResponse.removeHeaders("Transfer-Encoding");
        for (Header header : headers = httpResponse.getHeaders()) {
            servletResponse.addHeader(header.getName(), header.getValue());
        }
        this.ensureContentTypeHeaderIsSet(servletResponse, httpResponse);
        return servletResponse;
    }

    private void ensureContentTypeHeaderIsSet(HttpServletResponse servletResponse, HttpResponse httpResponse) {
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        String contentType = this.defaultContentType;
        if (this.contentTypeHeaderIsValid(contentTypeHeader)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using Content-Type from message header = " + contentTypeHeader.getValue()));
            }
            contentType = contentTypeHeader.getValue();
        }
        servletResponse.setContentType(contentType);
    }

    private boolean contentTypeHeaderIsValid(Header header) {
        return header != null && header.getValue() != null;
    }

    public ServletResponseWriter setFeedbackOnEmptyResponse(boolean feedbackOnEmptyResponse) {
        this.feedbackOnEmptyResponse = feedbackOnEmptyResponse;
        return this;
    }
}

