/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.reconnect;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.util.concurrent.ThreadNameHelper;

public class ReconnectWorkManager
implements WorkManager {
    private ExecutorService executor;
    private boolean isStarted = false;
    private MuleContext muleContext;

    public ReconnectWorkManager(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void dispose() {
        this.stop();
    }

    public void stop() {
        this.isStarted = false;
        this.executor.shutdownNow();
    }

    public void execute(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    public synchronized void startIfNotStarted() throws MuleException {
        if (!this.isStarted) {
            this.start();
        }
    }

    public void start() throws MuleException {
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, String.format("%s.endpoint.reconnection", ThreadNameHelper.getPrefix((MuleContext)ReconnectWorkManager.this.muleContext)));
            }
        });
        this.isStarted = true;
    }

    public void doWork(Work work) throws WorkException {
        throw new UnsupportedOperationException();
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new UnsupportedOperationException();
    }

    public long startWork(Work work) throws WorkException {
        throw new UnsupportedOperationException();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new UnsupportedOperationException();
    }

    public void scheduleWork(Work work) throws WorkException {
        this.executor.execute((Runnable)work);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static class WorkDelegate
    implements Work {
        private Work work;

        public void setWork(Work work) {
            this.work = work;
        }

        public void release() {
            this.work.release();
        }

        public void run() {
            this.work.run();
        }
    }
}

