/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.validate.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestData {
    private Object msgContext = null;
    private boolean noSerialization = false;
    private SOAPConstants soapConstants = null;
    private String actor = null;
    private String username = null;
    private String pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private String[] utElements = null;
    private Crypto sigCrypto = null;
    private Crypto decCrypto = null;
    private int sigKeyId = 0;
    private String sigAlgorithm = null;
    private String signatureDigestAlgorithm = null;
    private String encryptionDigestAlgorithm = null;
    private String signatureC14nAlgorithm;
    private List<WSEncryptionPart> signatureParts = new ArrayList<WSEncryptionPart>();
    private Crypto encCrypto = null;
    private int encKeyId = 0;
    private String encSymmAlgo = null;
    private String encKeyTransport = null;
    private String encUser = null;
    private String signatureUser = null;
    private List<WSEncryptionPart> encryptParts = new ArrayList<WSEncryptionPart>();
    private X509Certificate encCert = null;
    private int timeToLive = 300;
    private WSSConfig wssConfig = null;
    private List<byte[]> signatureValues = new ArrayList<byte[]>();
    private WSSecHeader secHeader = null;
    private boolean encSymmetricEncryptionKey = true;
    private int secretKeyLength = 16;
    private boolean useDerivedKey = true;
    private int derivedKeyIterations = 1000;
    private boolean useDerivedKeyForMAC = true;
    private boolean useSingleCert = true;
    private CallbackHandler callback = null;
    private boolean enableRevocation = false;
    protected boolean requireSignedEncryptedDataElements = false;
    private ReplayCache timestampReplayCache;
    private ReplayCache nonceReplayCache;
    private ReplayCache samlOneTimeUseReplayCache;
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();
    private boolean appendSignatureAfterTimestamp;
    private int originalSignatureActionPosition;
    private AlgorithmSuite algorithmSuite;
    private AlgorithmSuite samlAlgorithmSuite;
    private final List<String> audienceRestrictions = new ArrayList<String>();

    public void clear() {
        this.soapConstants = null;
        this.encUser = null;
        this.encKeyTransport = null;
        this.encSymmAlgo = null;
        this.sigAlgorithm = null;
        this.pwType = null;
        this.username = null;
        this.actor = null;
        this.encCrypto = null;
        this.decCrypto = null;
        this.sigCrypto = null;
        this.signatureParts.clear();
        this.encryptParts.clear();
        this.encCert = null;
        this.utElements = null;
        this.wssConfig = null;
        this.signatureValues.clear();
        this.signatureDigestAlgorithm = null;
        this.signatureC14nAlgorithm = null;
        this.encryptionDigestAlgorithm = null;
        this.encSymmetricEncryptionKey = true;
        this.secretKeyLength = 16;
        this.signatureUser = null;
        this.useDerivedKey = true;
        this.derivedKeyIterations = 1000;
        this.useDerivedKeyForMAC = true;
        this.useSingleCert = true;
        this.callback = null;
        this.enableRevocation = false;
        this.timestampReplayCache = null;
        this.nonceReplayCache = null;
        this.samlOneTimeUseReplayCache = null;
        this.subjectDNPatterns.clear();
        this.appendSignatureAfterTimestamp = false;
        this.algorithmSuite = null;
        this.samlAlgorithmSuite = null;
        this.setOriginalSignatureActionPosition(0);
        this.audienceRestrictions.clear();
    }

    public String getSignatureC14nAlgorithm() {
        return this.signatureC14nAlgorithm;
    }

    public void setSignatureC14nAlgorithm(String signatureC14nAlgorithm) {
        this.signatureC14nAlgorithm = signatureC14nAlgorithm;
    }

    public Object getMsgContext() {
        return this.msgContext;
    }

    public void setMsgContext(Object msgContext) {
        this.msgContext = msgContext;
    }

    public boolean isNoSerialization() {
        return this.noSerialization;
    }

    public void setNoSerialization(boolean noSerialization) {
        this.noSerialization = noSerialization;
    }

    public SOAPConstants getSoapConstants() {
        return this.soapConstants;
    }

    public void setSoapConstants(SOAPConstants soapConstants) {
        this.soapConstants = soapConstants;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSecretKeyLength(int length) {
        this.secretKeyLength = length;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEncryptSymmetricEncryptionKey(boolean encrypt) {
        this.encSymmetricEncryptionKey = encrypt;
    }

    public boolean getEncryptSymmetricEncryptionKey() {
        return this.encSymmetricEncryptionKey;
    }

    public String getPwType() {
        return this.pwType;
    }

    public void setPwType(String pwType) {
        this.pwType = pwType;
    }

    public String[] getUtElements() {
        return this.utElements;
    }

    public void setUtElements(String[] utElements) {
        this.utElements = utElements;
    }

    public Crypto getSigCrypto() {
        return this.sigCrypto;
    }

    public void setSigCrypto(Crypto sigCrypto) {
        this.sigCrypto = sigCrypto;
    }

    public Crypto getDecCrypto() {
        return this.decCrypto;
    }

    public void setDecCrypto(Crypto decCrypto) {
        this.decCrypto = decCrypto;
    }

    public int getSigKeyId() {
        return this.sigKeyId;
    }

    public void setSigKeyId(int sigKeyId) {
        this.sigKeyId = sigKeyId;
    }

    public String getSigAlgorithm() {
        return this.sigAlgorithm;
    }

    public void setSigAlgorithm(String sigAlgorithm) {
        this.sigAlgorithm = sigAlgorithm;
    }

    public String getSigDigestAlgorithm() {
        return this.signatureDigestAlgorithm;
    }

    public void setSigDigestAlgorithm(String sigDigestAlgorithm) {
        this.signatureDigestAlgorithm = sigDigestAlgorithm;
    }

    public String getEncDigestAlgorithm() {
        return this.encryptionDigestAlgorithm;
    }

    public void setEncDigestAlgorithm(String encDigestAlgorithm) {
        this.encryptionDigestAlgorithm = encDigestAlgorithm;
    }

    public List<WSEncryptionPart> getSignatureParts() {
        return this.signatureParts;
    }

    public String getSignatureUser() {
        return this.signatureUser;
    }

    public void setSignatureUser(String signatureUser) {
        this.signatureUser = signatureUser;
    }

    public Crypto getEncCrypto() {
        return this.encCrypto;
    }

    public void setEncCrypto(Crypto encCrypto) {
        this.encCrypto = encCrypto;
    }

    public int getEncKeyId() {
        return this.encKeyId;
    }

    public void setEncKeyId(int encKeyId) {
        this.encKeyId = encKeyId;
    }

    public String getEncSymmAlgo() {
        return this.encSymmAlgo;
    }

    public void setEncSymmAlgo(String encSymmAlgo) {
        this.encSymmAlgo = encSymmAlgo;
    }

    public String getEncKeyTransport() {
        return this.encKeyTransport;
    }

    public void setEncKeyTransport(String encKeyTransport) {
        this.encKeyTransport = encKeyTransport;
    }

    public String getEncUser() {
        return this.encUser;
    }

    public void setEncUser(String encUser) {
        this.encUser = encUser;
    }

    public List<WSEncryptionPart> getEncryptParts() {
        return this.encryptParts;
    }

    public X509Certificate getEncCert() {
        return this.encCert;
    }

    public void setEncCert(X509Certificate encCert) {
        this.encCert = encCert;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public WSSConfig getWssConfig() {
        return this.wssConfig;
    }

    public void setWssConfig(WSSConfig wssConfig) {
        this.wssConfig = wssConfig;
    }

    public List<byte[]> getSignatureValues() {
        return this.signatureValues;
    }

    public WSSecHeader getSecHeader() {
        return this.secHeader;
    }

    public void setSecHeader(WSSecHeader secHeader) {
        this.secHeader = secHeader;
    }

    public void setUseDerivedKey(boolean derivedKey) {
        this.useDerivedKey = derivedKey;
    }

    public boolean isUseDerivedKey() {
        return this.useDerivedKey;
    }

    public void setDerivedKeyIterations(int iterations) {
        this.derivedKeyIterations = iterations;
    }

    public int getDerivedKeyIterations() {
        return this.derivedKeyIterations;
    }

    public void setUseDerivedKeyForMAC(boolean useMac) {
        this.useDerivedKeyForMAC = useMac;
    }

    public boolean isUseDerivedKeyForMAC() {
        return this.useDerivedKeyForMAC;
    }

    public void setUseSingleCert(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public boolean isUseSingleCert() {
        return this.useSingleCert;
    }

    public void setEnableRevocation(boolean enableRevocation) {
        this.enableRevocation = enableRevocation;
    }

    public boolean isRevocationEnabled() {
        return this.enableRevocation;
    }

    public boolean isRequireSignedEncryptedDataElements() {
        return this.requireSignedEncryptedDataElements;
    }

    public void setRequireSignedEncryptedDataElements(boolean requireSignedEncryptedDataElements) {
        this.requireSignedEncryptedDataElements = requireSignedEncryptedDataElements;
    }

    public void setCallbackHandler(CallbackHandler cb) {
        this.callback = cb;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callback;
    }

    public Validator getValidator(QName qName) throws WSSecurityException {
        if (this.wssConfig != null) {
            return this.wssConfig.getValidator(qName);
        }
        return null;
    }

    public void setTimestampReplayCache(ReplayCache newCache) {
        this.timestampReplayCache = newCache;
    }

    public ReplayCache getTimestampReplayCache() {
        return this.timestampReplayCache;
    }

    public void setNonceReplayCache(ReplayCache newCache) {
        this.nonceReplayCache = newCache;
    }

    public ReplayCache getNonceReplayCache() {
        return this.nonceReplayCache;
    }

    public void setSamlOneTimeUseReplayCache(ReplayCache newCache) {
        this.samlOneTimeUseReplayCache = newCache;
    }

    public ReplayCache getSamlOneTimeUseReplayCache() throws WSSecurityException {
        return this.samlOneTimeUseReplayCache;
    }

    public void setSubjectCertConstraints(Collection<Pattern> subjectCertConstraints) {
        if (subjectCertConstraints != null) {
            this.subjectDNPatterns.addAll(subjectCertConstraints);
        }
    }

    public Collection<Pattern> getSubjectCertConstraints() {
        return this.subjectDNPatterns;
    }

    public void setAudienceRestrictions(List<String> audienceRestrictions) {
        if (audienceRestrictions != null) {
            this.audienceRestrictions.addAll(audienceRestrictions);
        }
    }

    public List<String> getAudienceRestrictions() {
        return this.audienceRestrictions;
    }

    public boolean isAppendSignatureAfterTimestamp() {
        return this.appendSignatureAfterTimestamp;
    }

    public void setAppendSignatureAfterTimestamp(boolean appendSignatureAfterTimestamp) {
        this.appendSignatureAfterTimestamp = appendSignatureAfterTimestamp;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public AlgorithmSuite getSamlAlgorithmSuite() {
        return this.samlAlgorithmSuite;
    }

    public void setSamlAlgorithmSuite(AlgorithmSuite samlAlgorithmSuite) {
        this.samlAlgorithmSuite = samlAlgorithmSuite;
    }

    public int getOriginalSignatureActionPosition() {
        return this.originalSignatureActionPosition;
    }

    public void setOriginalSignatureActionPosition(int originalSignatureActionPosition) {
        this.originalSignatureActionPosition = originalSignatureActionPosition;
    }
}

