/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.FloatingNode;
import org.raml.v2.internal.framework.nodes.IntegerNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class DivisorValueRule
extends Rule {
    private Number divisorValue;

    public DivisorValueRule(Number divisorValue) {
        this.divisorValue = divisorValue;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            if (this.divisorValue.intValue() == 0 && Integer.valueOf(0).equals(((IntegerNode)node).getValue())) {
                return true;
            }
            return this.divisorValue.intValue() != 0 && ((IntegerNode)node).getValue() % this.divisorValue.intValue() == 0;
        }
        return node instanceof FloatingNode && this.divisorValue.floatValue() != 0.0f && BigDecimal.ZERO.equals(((FloatingNode)node).getValue().divide(new BigDecimal(this.divisorValue.floatValue()), 7));
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        if (node instanceof IntegerNode && this.divisorValue.intValue() == 0 || node instanceof FloatingNode && this.divisorValue.floatValue() == 0.0f) {
            return ErrorNodeFactory.createInvalidDivisorValue();
        }
        return ErrorNodeFactory.createInvalidMultipleOfValue(this.divisorValue);
    }

    @Override
    public String getDescription() {
        return "Multiple of value";
    }
}

