/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.FloatingNode;
import org.raml.v2.internal.framework.nodes.IntegerNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class MinimumValueRule
extends Rule {
    private Number minimumValue;

    public MinimumValueRule(Number minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        BigDecimal value = null;
        if (node instanceof StringNode) {
            value = new BigDecimal(((StringNode)node).getValue());
        } else if (node instanceof IntegerNode) {
            value = BigDecimal.valueOf(((IntegerNode)node).getValue().intValue());
        } else if (node instanceof FloatingNode) {
            value = ((FloatingNode)node).getValue();
        }
        return value != null && value.compareTo(new BigDecimal(this.minimumValue.floatValue())) >= 0;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidMinimumValue(this.minimumValue);
    }

    @Override
    public String getDescription() {
        return "Minimum value";
    }
}

