/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.DefaultSuggestion;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class RegexValueRule
extends Rule {
    private Pattern value;
    private String description;
    private String suggestion;
    private String label;

    public RegexValueRule(Pattern value) {
        this.value = value;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        if (StringUtils.isEmpty((String)this.suggestion)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DefaultSuggestion(this.suggestion, this.description, this.label));
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode && this.getMatcher((StringNode)node).matches();
    }

    private Matcher getMatcher(StringNode node) {
        return this.value.matcher(node.getValue());
    }

    public RegexValueRule label(String value) {
        this.label = value;
        return this;
    }

    public RegexValueRule suggest(String value) {
        this.suggestion = value;
        return this;
    }

    public RegexValueRule description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, String.valueOf(this.value));
        }
        Matcher matcher = this.getMatcher((StringNode)node);
        int i = matcher.groupCount();
        ArrayList<String> groups = new ArrayList<String>();
        if (i > 0) {
            matcher.matches();
        }
        for (int j = 1; j <= i; ++j) {
            String group = matcher.group(j);
            groups.add(group);
        }
        return this.createNodeUsingFactory(node, groups.toArray(new String[groups.size()]));
    }

    @Override
    public String getDescription() {
        return "\"" + this.value + "\"";
    }
}

