/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.impl.commons.model.DocumentationItem;
import org.raml.v2.internal.impl.commons.model.GlobalSchema;
import org.raml.v2.internal.impl.commons.model.LibraryBase;
import org.raml.v2.internal.impl.commons.model.Resource;
import org.raml.v2.internal.impl.commons.model.SecuritySchemeRef;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.impl.commons.model.TypeDeclaration;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;

public class Api
extends LibraryBase {
    private RamlDocumentNode node;

    public Api(RamlDocumentNode delegateNode) {
        this.node = delegateNode;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    public String title() {
        return this.getStringValue("title");
    }

    public String version() {
        return this.getStringValue("version");
    }

    public StringType baseUri() {
        return this.getStringTypeValue("baseUri");
    }

    public List<StringType> mediaType() {
        return this.getListFromSeq("mediaType", StringType.class);
    }

    public List<DocumentationItem> documentation() {
        return this.getList("documentation", DocumentationItem.class);
    }

    public List<Resource> resources() {
        ArrayList<Resource> resultList = new ArrayList<Resource>();
        for (Node item : this.node.getChildren()) {
            if (!(item instanceof ResourceNode)) continue;
            resultList.add(new Resource((ResourceNode)item));
        }
        return resultList;
    }

    public List<String> protocols() {
        return this.getStringList("protocols");
    }

    public List<SecuritySchemeRef> securedBy() {
        return this.getList("securedBy", SecuritySchemeRef.class);
    }

    public List<GlobalSchema> schemasV08() {
        return this.getList("schemas", GlobalSchema.class);
    }

    public List<TypeDeclaration> baseUriParameters() {
        return this.getList("baseUriParameters", TypeDeclaration.class);
    }

    public String ramlVersion() {
        return this.node.getVersion().value();
    }
}

