/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.RamlNodeParser;
import org.raml.v2.internal.framework.phase.GrammarPhase;
import org.raml.v2.internal.framework.phase.Phase;
import org.raml.v2.internal.framework.phase.TransformationPhase;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.phase.AnnotationValidationPhase;
import org.raml.v2.internal.impl.commons.phase.ExampleValidationPhase;
import org.raml.v2.internal.impl.commons.phase.ExtensionsMerger;
import org.raml.v2.internal.impl.commons.phase.IncludeResolver;
import org.raml.v2.internal.impl.commons.phase.ReferenceResolverTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsTransformer;
import org.raml.v2.internal.impl.commons.phase.SchemaValidationPhase;
import org.raml.v2.internal.impl.commons.phase.StringTemplateExpressionTransformer;
import org.raml.v2.internal.impl.commons.phase.SugarRushPhase;
import org.raml.v2.internal.impl.v10.RamlFragment;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.phase.MediaTypeInjection;
import org.raml.v2.internal.impl.v10.phase.TypesTransformer;
import org.raml.v2.internal.utils.StreamUtils;

public class Raml10Builder {
    public Node build(String stringContent, RamlFragment fragment, ResourceLoader resourceLoader, String resourceLocation, int maxPhaseNumber) throws IOException {
        Node rootNode = RamlNodeParser.parse(stringContent, true);
        if (rootNode == null) {
            return ErrorNodeFactory.createEmptyDocument();
        }
        boolean applyExtension = false;
        if (fragment == RamlFragment.Extension && maxPhaseNumber > RamlBuilder.FIRST_PHASE) {
            applyExtension = true;
            maxPhaseNumber = RamlBuilder.SUGAR_PHASE;
        }
        List<Phase> phases = this.createPhases(resourceLoader, resourceLocation, fragment);
        for (int i = 0; i < phases.size(); ++i) {
            Phase phase;
            List<ErrorNode> errorNodes;
            if (i >= maxPhaseNumber || (errorNodes = (rootNode = (phase = phases.get(i)).apply(rootNode)).findDescendantsWith(ErrorNode.class)).isEmpty()) continue;
            return rootNode;
        }
        if (applyExtension && rootNode.findDescendantsWith(ErrorNode.class).isEmpty()) {
            return this.applyExtension(rootNode, resourceLoader, resourceLocation);
        }
        return rootNode;
    }

    private Node applyExtension(Node extensionNode, ResourceLoader resourceLoader, String resourceLocation) throws IOException {
        RamlBuilder builder = new RamlBuilder(RamlBuilder.SUGAR_PHASE);
        StringNode baseRef = (StringNode)extensionNode.get("extends");
        InputStream baseStream = resourceLoader.fetchResource(baseRef.getValue());
        String baseContent = StreamUtils.toString(baseStream);
        Node baseNode = builder.build(baseContent, resourceLoader, resourceLocation);
        if (!baseNode.findDescendantsWith(ErrorNode.class).isEmpty()) {
            return baseNode;
        }
        if (this.isOverlayOrExtension(baseContent)) {
            this.applyExtension(baseNode, resourceLoader, resourceLocation);
        }
        ExtensionsMerger.merge(baseNode, extensionNode);
        return baseNode;
    }

    private boolean isOverlayOrExtension(String baseContent) throws IOException {
        try {
            RamlHeader ramlHeader = RamlHeader.parse(baseContent);
            if (ramlHeader.getFragment() == RamlFragment.Extension || ramlHeader.getFragment() == RamlFragment.Overlay) {
                return true;
            }
        }
        catch (RamlHeader.InvalidHeaderException invalidHeaderException) {
            // empty catch block
        }
        return false;
    }

    private List<Phase> createPhases(ResourceLoader resourceLoader, String resourceLocation, RamlFragment fragment) {
        TransformationPhase first = new TransformationPhase(new IncludeResolver(resourceLoader, resourceLocation), new StringTemplateExpressionTransformer());
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        GrammarPhase second = new GrammarPhase(fragment.getRule(raml10Grammar));
        SugarRushPhase sugar = new SugarRushPhase();
        TransformationPhase referenceCheck = new TransformationPhase(new ReferenceResolverTransformer());
        TransformationPhase third = new TransformationPhase(new ResourceTypesTraitsTransformer(raml10Grammar));
        TransformationPhase typesTransformation = new TransformationPhase(new TypesTransformer(resourceLocation));
        GrammarPhase thirdAndAHalf = second;
        AnnotationValidationPhase fourth = new AnnotationValidationPhase();
        MediaTypeInjection fifth = new MediaTypeInjection();
        SchemaValidationPhase sixth = new SchemaValidationPhase(resourceLoader);
        ExampleValidationPhase seventh = new ExampleValidationPhase(resourceLoader);
        return Arrays.asList(first, sugar, second, referenceCheck, third, typesTransformation, thirdAndAHalf, fourth, fifth, sixth, seventh);
    }
}

