/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.api.MuleEvent;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.annotations.param.UseConfig;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ObjectSource;
import org.mule.extension.validation.internal.ValidationExtension;
import org.mule.extension.validation.internal.ValidationOptions;
import org.mule.extension.validation.internal.ValidationSupport;

public final class CustomValidatorOperation
extends ValidationSupport {
    private final LoadingCache<ValidatorSource, Validator> class2ValidatorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ValidatorSource, Validator>(){

        public Validator load(ValidatorSource validatorSource) throws Exception {
            return validatorSource.createValidator();
        }
    });

    @Operation
    public void customValidator(@ParameterGroup ObjectSource<Validator> source, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidatorSource validatorSource = new ValidatorSource(source.getType(), source.getRef());
        Validator validator = (Validator)validatorSource.getObject(event.getMuleContext());
        this.validateWith(validator, this.createContext(options, event, config), event);
    }

    @Override
    protected void logSuccessfulValidation(Validator validator, MuleEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully executed custom validator of type {} on message: {}", (Object)validator.getClass().getName(), (Object)event.getMessage());
        }
    }

    private class ValidatorSource
    extends ObjectSource<Validator> {
        public ValidatorSource(String type, String ref) {
            super(type, ref);
        }

        @Override
        protected Validator doGetByClassName() {
            return (Validator)CustomValidatorOperation.this.class2ValidatorCache.getUnchecked((Object)this);
        }

        private Validator createValidator() {
            return (Validator)super.doGetByClassName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValidatorSource) {
                return this.getType().equals(((ValidatorSource)obj).getType());
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode();
        }
    }
}

