/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.processor.SequentialStageNameSource;
import org.mule.api.processor.StageNameSource;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SequentialStageNameSourceTest {
    private static final String NAME = "name";
    private StageNameSource source;

    @Before
    public void setUp() {
        this.source = new SequentialStageNameSource(NAME);
    }

    @Test
    public void getName() {
        int count = 10;
        for (int i = 1; i <= 10; ++i) {
            junit.framework.Assert.assertEquals((String)String.format("%s.%s", NAME, i), (String)this.source.getName());
        }
    }

    @Test
    public void threadSafe() throws Exception {
        int count = 10;
        final Set names = Collections.synchronizedSet(new HashSet());
        final CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    names.add(SequentialStageNameSourceTest.this.source.getName());
                    latch.countDown();
                }
            }.start();
        }
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        junit.framework.Assert.assertEquals((int)10, (int)names.size());
    }
}

