/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleSession;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.security.Authentication;
import org.mule.api.security.Credentials;
import org.mule.api.security.SecurityContext;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.construct.Flow;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.DefaultSecurityContextFactory;
import org.mule.security.MuleCredentials;
import org.mule.serialization.internal.JavaObjectSerializer;
import org.mule.session.DefaultMuleSession;

public class DefaultMuleSessionTestCase {
    private static final int LATCH_TIMEOUT = 1000;
    private ObjectSerializer serializer;

    @Before
    public void before() {
        this.serializer = new JavaObjectSerializer();
    }

    @Test
    public void create() {
        DefaultMuleSession session = new DefaultMuleSession();
        this.assertCreate(session);
    }

    protected void assertCreate(DefaultMuleSession session) {
        Assert.assertNotNull((Object)session.getId());
        Assert.assertNull((Object)session.getSecurityContext());
        Assert.assertNotNull((Object)session.getPropertyNamesAsSet());
        Assert.assertTrue((boolean)session.getPropertyNamesAsSet().isEmpty());
        Assert.assertTrue((boolean)session.isValid());
    }

    @Test
    public void copy() throws Exception {
        DefaultMuleSession original = new DefaultMuleSession();
        original.setValid(false);
        original.setSecurityContext((SecurityContext)Mockito.mock(SecurityContext.class));
        original.setProperty("foo", (Serializable)((Object)"bar"));
        DefaultMuleSession copy = new DefaultMuleSession((MuleSession)original);
        this.assertCopy(original, copy);
        Assert.assertSame((Object)original.getProperty("foo"), (Object)copy.getProperty("foo"));
        copy.setProperty("new", (Serializable)((Object)"bar"));
        Assert.assertNull((Object)original.getProperty("new"));
    }

    protected void assertCopy(DefaultMuleSession original, DefaultMuleSession copy) {
        Assert.assertSame((Object)copy.getId(), (Object)original.getId());
        Assert.assertSame((Object)copy.isValid(), (Object)original.isValid());
        Assert.assertSame((Object)copy.getSecurityContext(), (Object)original.getSecurityContext());
    }

    @Test
    public void valid() {
        DefaultMuleSession session = new DefaultMuleSession();
        Assert.assertTrue((boolean)session.isValid());
        session.setValid(false);
        Assert.assertFalse((boolean)session.isValid());
        session.setValid(true);
        Assert.assertTrue((boolean)session.isValid());
    }

    @Test
    public void propertiesCaseInsensitive() {
        DefaultMuleSession session = new DefaultMuleSession();
        session.setProperty("key1", (Serializable)((Object)"value1"));
        Assert.assertSame((Object)"value1", (Object)session.getProperty("key1"));
        session.setProperty("KEY1", (Serializable)((Object)"value2"));
        Assert.assertSame((Object)"value2", (Object)session.getProperty("key1"));
    }

    @Test
    public void propertiesCaseInsensitiveAfterCopy() {
        DefaultMuleSession original = new DefaultMuleSession();
        DefaultMuleSession copy = new DefaultMuleSession((MuleSession)original);
        copy.setProperty("key1", (Serializable)((Object)"value1"));
        Assert.assertSame((Object)"value1", (Object)copy.getProperty("key1"));
        copy.setProperty("KEY1", (Serializable)((Object)"value2"));
        Assert.assertSame((Object)"value2", (Object)copy.getProperty("key1"));
    }

    @Test
    public void merge() {
        DefaultMuleSession copy1 = new DefaultMuleSession();
        DefaultMuleSession copy2 = new DefaultMuleSession();
        Object nonSerializableValue2 = new Object();
        Object nonSerializableValue3 = new Object();
        copy1.setProperty("key1", (Serializable)((Object)"value1"));
        copy1.setProperty("key2", nonSerializableValue2);
        copy1.setProperty("key3", nonSerializableValue3);
        copy1.setProperty("key4", (Serializable)((Object)"value4"));
        copy1.setProperty("key5", (Serializable)((Object)"value5"));
        copy1.setProperty("key6", (Serializable)((Object)"value6"));
        copy2.setProperty("key1", (Serializable)((Object)"value1"));
        copy2.setProperty("key2", (Serializable)((Object)"value2"));
        copy2.setProperty("KEY4", (Serializable)((Object)"value4"));
        copy2.setProperty("KEY5", (Serializable)((Object)"value5NEW"));
        copy2.setProperty("key7", (Serializable)((Object)"value7"));
        int copy2PropertiesHashCode = copy2.getPropertyNamesAsSet().hashCode();
        copy1.merge((MuleSession)copy2);
        Assert.assertEquals((long)6L, (long)copy1.getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value1", (Object)copy1.getProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)copy1.getProperty("key2"));
        Assert.assertEquals((Object)nonSerializableValue3, (Object)copy1.getProperty("key3"));
        Assert.assertEquals((Object)"value4", (Object)copy1.getProperty("key4"));
        Assert.assertEquals((Object)"value5NEW", (Object)copy1.getProperty("key5"));
        Assert.assertNull((Object)copy1.getProperty("key6"));
        Assert.assertEquals((Object)"value7", (Object)copy1.getProperty("key7"));
        Assert.assertEquals((long)5L, (long)copy2.getPropertyNamesAsSet().size());
        Assert.assertEquals((long)copy2PropertiesHashCode, (long)copy2.getPropertyNamesAsSet().hashCode());
    }

    @Test
    public void serialization() throws MuleException {
        Flow flow = new Flow("flow", (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        DefaultMuleSession before = new DefaultMuleSession();
        before.setValid(false);
        before.setSecurityContext(this.createTestAuthentication());
        before.setProperty("foo", (Serializable)((Object)"bar"));
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)muleContext.getRegistry()).thenReturn((Object)registry);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        Mockito.when((Object)registry.lookupFlowConstruct("flow")).thenReturn((Object)flow);
        ((MuleContextAware)this.serializer).setMuleContext(muleContext);
        DefaultMuleSession after = (DefaultMuleSession)this.serializer.deserialize(this.serializer.serialize((Object)before));
        Assert.assertEquals((Object)before.getId(), (Object)after.getId());
        Assert.assertEquals((Object)before.isValid(), (Object)after.isValid());
        Assert.assertEquals((Object)before.getProperty("foo"), (Object)after.getProperty("foo"));
        Assert.assertEquals((Object)before.getSecurityContext().getAuthentication().getPrincipal(), (Object)after.getSecurityContext().getAuthentication().getPrincipal());
        Assert.assertEquals(before.getSecurityContext().getAuthentication().getProperties().get("key1"), after.getSecurityContext().getAuthentication().getProperties().get("key1"));
        Assert.assertEquals((Object)before.getSecurityContext().getAuthentication().getCredentials(), (Object)after.getSecurityContext().getAuthentication().getCredentials());
        after.setProperty("new", (Serializable)((Object)"value"));
        Assert.assertNull((Object)before.getProperty("new"));
    }

    @Test
    public void serializationWithNonSerializableProperty() throws MuleException {
        DefaultMuleSession before = new DefaultMuleSession();
        Object nonSerializable = new Object();
        before.setProperty("foo", nonSerializable);
        before.setProperty("foo2", (Serializable)((Object)"bar2"));
        MuleSession after = (MuleSession)this.serializer.deserialize(this.serializer.serialize((Object)before), this.getClass().getClassLoader());
        Assert.assertNotNull((Object)after);
        Assert.assertNotSame((Object)after, (Object)before);
        Assert.assertEquals((Object)"bar2", (Object)after.getProperty("foo2"));
        Assert.assertNull((Object)after.getProperty("foo"));
    }

    private SecurityContext createTestAuthentication() {
        DefaultMuleAuthentication auth = new DefaultMuleAuthentication((Credentials)new MuleCredentials("dan", new char[]{'d', 'f'}));
        auth.setProperties(Collections.singletonMap("key1", "value1"));
        SecurityContext securityContext = new DefaultSecurityContextFactory().create((Authentication)auth);
        return securityContext;
    }
}

