/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;

public class CountersTestCase
extends AbstractMuleTestCase {
    private static final double delta = 1.0E-10;

    @Test
    public void testCreate() {
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create1", (CounterFactory.Type)CounterFactory.Type.NUMBER));
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create2", (CounterFactory.Type)CounterFactory.Type.NUMBER, (boolean)false));
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create3", (String)"create1", (CounterFactory.Type)CounterFactory.Type.MIN));
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create4", (String)"create1", (CounterFactory.Type)CounterFactory.Type.MIN, (boolean)false));
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create5", (String)"create1", (String)"create2", (CounterFactory.Type)CounterFactory.Type.PLUS));
        Assert.assertNotNull((Object)CounterFactory.createCounter((String)"create6", (String)"create1", (String)"create2", (CounterFactory.Type)CounterFactory.Type.PLUS, (boolean)false));
        Assert.assertNotNull((Object)CounterFactory.getCounter((String)"create1"));
        Assert.assertNull((Object)CounterFactory.getCounter((String)"zzz"));
        Iterator it = CounterFactory.getCounters();
        while (it.hasNext()) {
            Counter ct = (Counter)it.next();
            Assert.assertNotNull((Object)ct);
        }
        try {
            CounterFactory.createCounter((String)"create1", (CounterFactory.Type)CounterFactory.Type.NUMBER);
            Assert.fail((String)"The creation of a duplicate counter should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNumber() {
        Counter ct = CounterFactory.createCounter((String)"testNumber", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Assert.assertEquals((String)"Default value", (double)0.0, (double)ct.nextValue(), (double)1.0E-10);
        ct.setRawValue(10.0);
        Assert.assertEquals((String)"setRawValue", (double)10.0, (double)ct.nextValue(), (double)1.0E-10);
        ct.increment();
        Assert.assertEquals((String)"increment", (double)11.0, (double)ct.nextValue(), (double)1.0E-10);
        ct.incrementBy(2.0);
        Assert.assertEquals((String)"incrementBy", (double)13.0, (double)ct.nextValue(), (double)1.0E-10);
        ct.decrement();
        Assert.assertEquals((String)"decrement", (double)12.0, (double)ct.nextValue(), (double)1.0E-10);
    }

    @Test
    public void testMinMax() {
        Counter ct = CounterFactory.createCounter((String)"testMinMax", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Counter min = CounterFactory.createCounter((String)"testMinMax.min", (String)"testMinMax", (CounterFactory.Type)CounterFactory.Type.MIN);
        Counter max = CounterFactory.createCounter((String)"testMinMax.max", (String)"testMinMax", (CounterFactory.Type)CounterFactory.Type.MAX);
        Assert.assertEquals((String)"Min default value", (double)Double.MAX_VALUE, (double)min.nextValue(), (double)1.0E-10);
        Assert.assertEquals((String)"Max default value", (double)Double.MIN_VALUE, (double)max.nextValue(), (double)1.0E-10);
        ct.setRawValue(10.0);
        ct.setRawValue(12.0);
        ct.setRawValue(18.0);
        ct.setRawValue(16.0);
        Assert.assertEquals((String)"Min", (double)10.0, (double)min.nextValue(), (double)1.0E-10);
        Assert.assertEquals((String)"Max", (double)18.0, (double)max.nextValue(), (double)1.0E-10);
    }

    @Test
    public void testDelta() {
        Counter ct = CounterFactory.createCounter((String)"testDelta", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Counter dt = CounterFactory.createCounter((String)"testDelta.delta", (String)"testDelta", (CounterFactory.Type)CounterFactory.Type.DELTA);
        Assert.assertEquals((String)"Default value", (double)0.0, (double)dt.nextValue(), (double)1.0E-10);
        ct.setRawValue(10.0);
        Assert.assertEquals((String)"First value", (double)10.0, (double)dt.nextValue(), (double)1.0E-10);
        ct.setRawValue(12.0);
        Assert.assertEquals((String)"Delta", (double)2.0, (double)dt.nextValue(), (double)1.0E-10);
        ct.setRawValue(18.0);
        Assert.assertEquals((String)"Delta", (double)6.0, (double)dt.nextValue(), (double)1.0E-10);
        ct.setRawValue(16.0);
        Assert.assertEquals((String)"Delta", (double)0.0, (double)dt.nextValue(), (double)1.0E-10);
    }

    @Test
    public void testSum() {
        Counter ct = CounterFactory.createCounter((String)"testSum", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Counter sum = CounterFactory.createCounter((String)"testSum.sum", (String)"testSum", (CounterFactory.Type)CounterFactory.Type.SUM);
        Assert.assertEquals((String)"Default value", (double)0.0, (double)sum.nextValue(), (double)1.0E-10);
        ct.setRawValue(10.0);
        Assert.assertEquals((String)"First value", (double)10.0, (double)sum.nextValue(), (double)1.0E-10);
        ct.setRawValue(12.0);
        Assert.assertEquals((String)"Sum", (double)22.0, (double)sum.nextValue(), (double)1.0E-10);
        ct.setRawValue(18.0);
        Assert.assertEquals((String)"Sum", (double)40.0, (double)sum.nextValue(), (double)1.0E-10);
        ct.setRawValue(16.0);
        Assert.assertEquals((String)"Sum", (double)56.0, (double)sum.nextValue(), (double)1.0E-10);
    }

    @Test
    public void testAverage() {
        Counter ct = CounterFactory.createCounter((String)"testAverage", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Counter avg = CounterFactory.createCounter((String)"testAverage.avg", (String)"testAverage", (CounterFactory.Type)CounterFactory.Type.AVERAGE);
        Assert.assertEquals((String)"Default value", (double)0.0, (double)avg.nextValue(), (double)1.0E-10);
        ct.setRawValue(10.0);
        Assert.assertEquals((String)"First value", (double)10.0, (double)avg.nextValue(), (double)1.0E-10);
        ct.setRawValue(12.0);
        Assert.assertEquals((String)"Average", (double)11.0, (double)avg.nextValue(), (double)1.0E-10);
        ct.setRawValue(18.0);
        Assert.assertEquals((String)"Average", (double)13.333333333333334, (double)avg.nextValue(), (double)1.0E-10);
        ct.setRawValue(16.0);
        Assert.assertEquals((String)"Average", (double)14.0, (double)avg.nextValue(), (double)1.0E-10);
    }

    public void _disabled_testInstantRate() throws InterruptedException {
        Counter ct = CounterFactory.createCounter((String)"testRate", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Counter rate = CounterFactory.createCounter((String)"testRate.rate", (String)"testRate", (CounterFactory.Type)CounterFactory.Type.INSTANT_RATE);
        Assert.assertTrue((String)"InstantRate", (boolean)Double.isNaN(rate.nextValue()));
        Thread.sleep(10L);
        ct.setRawValue(1.0);
        Assert.assertTrue((String)"InstantRate", (boolean)Double.isNaN(rate.nextValue()));
        Thread.sleep(100L);
        ct.setRawValue(20.0);
        Assert.assertEquals((String)"InstantRate", (double)200.0, (double)rate.nextValue(), (double)40.0);
        Thread.sleep(300L);
        ct.setRawValue(30.0);
        Assert.assertEquals((String)"InstantRate", (double)100.0, (double)rate.nextValue(), (double)20.0);
        ct.setRawValue(30.0);
        ct.setRawValue(30.0);
        Assert.assertTrue((String)"InstantRate", (boolean)Double.isNaN(rate.nextValue()));
    }

    @Test
    public void testRatePerUnit() throws InterruptedException {
        Counter ct = CounterFactory.createCounter((String)"testRatePerUnit", (CounterFactory.Type)CounterFactory.Type.NUMBER);
        Assert.assertNotNull((Object)ct);
        Counter rsec = CounterFactory.createCounter((String)"testRatePerUnit.rate.sec", (String)"testRatePerUnit", (CounterFactory.Type)CounterFactory.Type.RATE_PER_SECOND);
        Assert.assertNotNull((Object)rsec);
        Counter rmin = CounterFactory.createCounter((String)"testRatePerUnit.rate.min", (String)"testRatePerUnit", (CounterFactory.Type)CounterFactory.Type.RATE_PER_MINUTE);
        Assert.assertNotNull((Object)rmin);
        Assert.assertEquals((String)"Rate", (double)0.0, (double)rsec.nextValue(), (double)1.0E-10);
        for (int i = 0; i < 5; ++i) {
            ct.setRawValue(10.0);
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"RatePerSecond", (double)10.0, (double)rsec.nextValue(), (double)2.0);
        Assert.assertEquals((String)"RatePerMinute", (double)50.0, (double)rmin.nextValue(), (double)2.0);
    }
}

