/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;

public abstract class BaseConnectorMessageNotification
extends ServerNotification {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Log logger = LogFactory.getLog(BaseConnectorMessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_RESPONSE = 805;
    public static final int MESSAGE_ERROR_RESPONSE = 806;
    public static final int MESSAGE_REQUEST_BEGIN = 804;
    public static final int MESSAGE_REQUEST_END = 853;
    private String endpoint;
    private FlowConstruct flowConstruct;

    public BaseConnectorMessageNotification(MuleMessage resource, String endpoint, FlowConstruct flowConstruct, int action) {
        super(BaseConnectorMessageNotification.cloneMessage(resource), action, flowConstruct != null ? flowConstruct.getName() : null);
        this.endpoint = endpoint;
        this.flowConstruct = flowConstruct;
    }

    @Override
    protected String getPayloadToString() {
        try {
            return ((MuleMessage)this.source).getPayloadAsString();
        }
        catch (Exception e) {
            return this.source.toString();
        }
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + BaseConnectorMessageNotification.getActionName(this.action) + ", endpoint: " + this.endpoint + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public String getType() {
        return "trace";
    }

    @Override
    public MuleMessage getSource() {
        return (MuleMessage)super.getSource();
    }

    static {
        BaseConnectorMessageNotification.registerAction("receive", 801);
        BaseConnectorMessageNotification.registerAction("response", 805);
        BaseConnectorMessageNotification.registerAction("error response", 806);
        BaseConnectorMessageNotification.registerAction("begin request", 804);
        BaseConnectorMessageNotification.registerAction("end request", 853);
    }
}

