/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.el.mvel.datatype.FlowVarEnricherDataTypePropagator;
import org.mule.el.mvel.datatype.PayloadEnricherDataTypePropagator;
import org.mule.el.mvel.datatype.PropertyEnricherDataTypePropagator;
import org.mule.el.mvel.datatype.SessionVarEnricherDataTypePropagator;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.transformer.types.TypedValue;

public class MvelEnricherDataTypePropagator {
    private final List<EnricherDataTypePropagator> propagators;

    public MvelEnricherDataTypePropagator() {
        this(MvelEnricherDataTypePropagator.getDefaultDataTypePropagators());
    }

    public MvelEnricherDataTypePropagator(List<EnricherDataTypePropagator> propagators) {
        this.propagators = new LinkedList<EnricherDataTypePropagator>(propagators);
    }

    private static List<EnricherDataTypePropagator> getDefaultDataTypePropagators() {
        LinkedList<EnricherDataTypePropagator> propagators = new LinkedList<EnricherDataTypePropagator>();
        propagators.add(new PayloadEnricherDataTypePropagator());
        propagators.add(new PropertyEnricherDataTypePropagator());
        propagators.add(new FlowVarEnricherDataTypePropagator());
        propagators.add(new SessionVarEnricherDataTypePropagator());
        return propagators;
    }

    public void propagate(TypedValue typedValue, MuleMessage message, Serializable serializedExpression) {
        if (serializedExpression instanceof CompiledExpression) {
            CompiledExpression compiledExpression = (CompiledExpression)serializedExpression;
            for (EnricherDataTypePropagator propagator : this.propagators) {
                if (!propagator.propagate(message, typedValue, compiledExpression)) continue;
                return;
            }
        }
    }
}

