/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.async;

import java.util.Map;
import javax.resource.spi.work.WorkException;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.retry.async.FutureRetryContext;
import org.mule.retry.async.RetryWorker;
import org.mule.util.concurrent.Latch;

public class AsynchronousRetryTemplate
implements RetryPolicyTemplate {
    private final RetryPolicyTemplate delegate;
    private Latch startLatch;

    public AsynchronousRetryTemplate(RetryPolicyTemplate delegate) {
        this.delegate = delegate;
    }

    @Override
    public RetryContext execute(RetryCallback callback, WorkManager workManager) throws Exception {
        if (workManager == null) {
            throw new IllegalStateException("Cannot schedule a work till the workManager is initialized. Probably the connector hasn't been initialized yet");
        }
        RetryWorker worker = new RetryWorker(this.delegate, callback, workManager, this.startLatch);
        FutureRetryContext context = worker.getRetryContext();
        try {
            workManager.scheduleWork(worker);
        }
        catch (WorkException e) {
            throw new RetryPolicyExhaustedException(e, callback.getWorkOwner());
        }
        return context;
    }

    @Override
    public RetryPolicy createRetryInstance() {
        return this.delegate.createRetryInstance();
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.delegate.getNotifier();
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.delegate.setNotifier(retryNotifier);
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.delegate.getMetaInfo();
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.delegate.setMetaInfo(metaInfo);
    }

    public RetryPolicyTemplate getDelegate() {
        return this.delegate;
    }

    public void setStartLatch(Latch latch) {
        this.startLatch = latch;
    }
}

