/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public class CompositeRoutingException
extends MessagingException {
    private static final String MESSAGE_TITLE = "Exception(s) were found for route(s): ";
    private static final long serialVersionUID = -4421728527040579607L;
    private final Map<Integer, Throwable> exceptions;

    public CompositeRoutingException(Message message, MuleEvent event, Map<Integer, Throwable> exceptions) {
        super(message, event);
        this.exceptions = Collections.unmodifiableMap(exceptions);
    }

    public CompositeRoutingException(MuleEvent event, Map<Integer, Throwable> exceptions) {
        this(CompositeRoutingException.buildExceptionMessage(exceptions), event, exceptions);
    }

    @Override
    protected String generateMessage(Message message) {
        return message.getMessage();
    }

    public Throwable getExceptionForRouteIndex(Integer index) {
        return this.exceptions.get(index);
    }

    public Map<Integer, Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getDetailedMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(MESSAGE_TITLE).append(SystemUtils.LINE_SEPARATOR);
        for (Map.Entry<Integer, Throwable> entry : this.getExceptions().entrySet()) {
            String routeSubtitle = String.format("Route %d:", entry.getKey());
            MuleException muleException = ExceptionHelper.getRootMuleException(entry.getValue());
            if (muleException != null) {
                builder.append(routeSubtitle).append(muleException.getDetailedMessage());
                continue;
            }
            builder.append(routeSubtitle).append("Caught exception in Exception Strategy: " + entry.getValue().getMessage());
        }
        return builder.toString();
    }

    private static Message buildExceptionMessage(Map<Integer, Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (Integer route : exceptions.keySet()) {
            Throwable routeException = exceptions.get(route);
            builder.append(SystemUtils.LINE_SEPARATOR + "\t").append(route).append(": ").append(routeException.getCause() != null ? routeException.getCause().getMessage() : routeException.getMessage());
        }
        builder.insert(0, MESSAGE_TITLE);
        return MessageFactory.createStaticMessage(builder.toString());
    }
}

