/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRoutingStrategy;

public class MulticastingRoutingStrategy
extends AbstractRoutingStrategy {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final RouterResultsHandler resultsHandler;

    public MulticastingRoutingStrategy(MuleContext muleContext, RouterResultsHandler resultAggregator) {
        super(muleContext);
        this.resultsHandler = resultAggregator;
    }

    @Override
    public MuleEvent route(MuleEvent event, List<MessageProcessor> messageProcessors) throws MessagingException {
        MuleMessage message = event.getMessage();
        if (messageProcessors == null || messageProcessors.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), event, null);
        }
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>(messageProcessors.size());
        MulticastingRoutingStrategy.validateMessageIsNotConsumable(event, message);
        try {
            for (int i = 0; i < messageProcessors.size(); ++i) {
                MessageProcessor mp = messageProcessors.get(i);
                MuleMessage clonedMessage = MulticastingRoutingStrategy.cloneMessage(message, this.getMuleContext());
                AbstractRoutingStrategy.propagateMagicProperties(clonedMessage, clonedMessage);
                MuleEvent result = this.sendRequest(event, clonedMessage, mp, true);
                if (result == null || VoidMuleEvent.getInstance().equals(result)) continue;
                results.add(result);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(event, messageProcessors.get(0), (Throwable)e);
        }
        return this.resultsHandler.aggregateResults(results, event, this.getMuleContext());
    }
}

