/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.NotSerializableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractUntilSuccessfulProcessingStrategy;

public class SynchronousUntilSuccessfulProcessingStrategy
extends AbstractUntilSuccessfulProcessingStrategy
implements Initialisable {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected MuleEvent doRoute(MuleEvent event) throws MessagingException {
        Exception lastExecutionException = null;
        MuleEvent retryEvent = this.copyEventForRetry(event);
        try {
            for (int i = 0; i <= this.getUntilSuccessfulConfiguration().getMaxRetries(); ++i) {
                try {
                    return this.processResponseThroughAckResponseExpression(this.processEvent(retryEvent));
                }
                catch (Exception e) {
                    this.logger.info((Object)("Exception thrown inside until-successful " + e.getMessage()));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)e);
                    }
                    lastExecutionException = e;
                    if (i >= this.getUntilSuccessfulConfiguration().getMaxRetries()) continue;
                    Thread.sleep(this.getUntilSuccessfulConfiguration().getMillisBetweenRetries());
                    retryEvent = this.copyEventForRetry(event);
                    continue;
                }
            }
            throw new RoutingException(retryEvent, this.getUntilSuccessfulConfiguration().getRouter(), lastExecutionException);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingException(retryEvent, this.getUntilSuccessfulConfiguration().getRouter(), (Throwable)e);
        }
    }

    private MuleEvent copyEventForRetry(MuleEvent event) {
        return OptimizedRequestContext.unsafeSetEvent(DefaultMuleEvent.copy(event));
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.getUntilSuccessfulConfiguration().getThreadingProfile() != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage("Until successful cannot be configured to be synchronous and have a threading profile at the same time"), (Initialisable)this);
        }
        if (this.getUntilSuccessfulConfiguration().getObjectStore() != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage("Until successful cannot be configured to be synchronous and use an object store."), (Initialisable)this);
        }
        if (this.getUntilSuccessfulConfiguration().getDlqMP() != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage("Until successful cannot be configured to be synchronous and use a dead letter queue. Failure must be processed with exception strategy"), (Initialisable)this);
        }
    }

    @Override
    protected void ensureSerializable(MuleMessage message) throws NotSerializableException {
    }
}

