/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.ObjectFilter;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class WildcardFilter
implements Filter,
ObjectFilter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile String pattern;
    protected volatile String[] patterns;
    private volatile boolean caseSensitive = true;

    public WildcardFilter() {
    }

    public WildcardFilter(String pattern) {
        this.setPattern(pattern);
    }

    @Override
    public boolean accept(MuleMessage message) {
        try {
            return this.accept(message.getPayloadAsString());
        }
        catch (Exception e) {
            this.logger.warn((Object)"An exception occurred while filtering", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean accept(Object object) {
        if (object == null || this.pattern == null) {
            return false;
        }
        if (this.pattern.equals(object)) {
            return true;
        }
        String[] currentPatterns = this.patterns;
        if (currentPatterns != null) {
            for (String pattern : currentPatterns) {
                boolean foundMatch;
                int firstWildcardIndex;
                if ("*".equals(pattern) || "**".equals(pattern)) {
                    return true;
                }
                String candidate = object.toString();
                if (!this.isCaseSensitive()) {
                    pattern = pattern.toLowerCase();
                    candidate = candidate.toLowerCase();
                }
                if ((firstWildcardIndex = pattern.indexOf(42)) == -1) {
                    foundMatch = pattern.equals(candidate);
                } else {
                    int secondWildcardIndex = pattern.indexOf(42, firstWildcardIndex + 1);
                    if (firstWildcardIndex == 0 && secondWildcardIndex == pattern.length() - 1) {
                        foundMatch = candidate.indexOf(pattern.substring(1, secondWildcardIndex)) > -1;
                    } else if (firstWildcardIndex == 0 && secondWildcardIndex == -1) {
                        foundMatch = candidate.endsWith(pattern.substring(1));
                    } else if (firstWildcardIndex == pattern.length() - 1) {
                        foundMatch = candidate.startsWith(pattern.substring(0, firstWildcardIndex));
                    } else {
                        this.logger.warn((Object)String.format("wildcard-filter only supports wildcards as prefix (*.log), suffix (java.util.*) or enclosing strings (*util*). Consider using a regex-filter instead for pattern: %s.", pattern));
                        foundMatch = false;
                    }
                }
                if (foundMatch) {
                    return true;
                }
                if (!pattern.endsWith("+") || pattern.length() <= 1) continue;
                this.logger.warn((Object)"wildcard-filter for payload based filtering is deprecated. Use expression-filter or payload-type-filter instead");
                return this.filterByClassName(object, pattern);
            }
        }
        return false;
    }

    @Deprecated
    private boolean filterByClassName(Object object, String pattern) {
        String className = pattern.substring(0, pattern.length() - 1);
        try {
            Class theClass = ClassUtils.loadClass(className, this.getClass());
            if (!(object instanceof String) ? theClass.isInstance(object) : theClass.isAssignableFrom(ClassUtils.loadClass(object.toString(), this.getClass()))) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patterns = StringUtils.splitAndTrim(pattern, ",");
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardFilter other = (WildcardFilter)obj;
        return ClassUtils.equal(this.pattern, other.pattern) && ClassUtils.equal(this.patterns, other.patterns) && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.pattern, this.patterns, this.caseSensitive});
    }
}

