/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.util.ClassUtils;

public class CaseInsensitiveMapWrapper<T>
implements Map<String, T>,
Serializable {
    private final Map<CaseInsensitiveMapKey, T> baseMap;

    public CaseInsensitiveMapWrapper(Class<? extends Map> mapClass, Object ... parameters) {
        try {
            this.baseMap = ClassUtils.instanciateClass(mapClass, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can not create an instance of %s", mapClass.getCanonicalName()), e);
        }
    }

    @Override
    public int size() {
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.baseMap.containsKey(new CaseInsensitiveMapKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.baseMap.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.baseMap.get(new CaseInsensitiveMapKey(key));
    }

    @Override
    public T put(String key, T value) {
        return this.baseMap.put(new CaseInsensitiveMapKey(key), value);
    }

    @Override
    public T remove(Object key) {
        return this.baseMap.remove(new CaseInsensitiveMapKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> other) {
        if (other instanceof CaseInsensitiveMapWrapper) {
            this.baseMap.putAll(((CaseInsensitiveMapWrapper)other).baseMap);
        } else {
            for (Map.Entry<String, T> otherEntry : other.entrySet()) {
                this.put(otherEntry.getKey(), otherEntry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.baseMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.baseMap.keySet());
    }

    @Override
    public Collection<T> values() {
        return this.baseMap.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new EntrySet<T>(this.baseMap.entrySet());
    }

    private static abstract class AbstractConverterIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> aIterator;

        public AbstractConverterIterator(Set<A> set) {
            this.aIterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.aIterator.hasNext();
        }

        @Override
        public final void remove() {
            this.aIterator.remove();
        }

        @Override
        public final B next() {
            return this.convert(this.aIterator.next());
        }

        protected abstract B convert(A var1);
    }

    private static class EntryIterator<T>
    extends AbstractConverterIterator<Map.Entry<CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntryIterator(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Map.Entry<String, T> convert(Map.Entry<CaseInsensitiveMapKey, T> next) {
            return new AbstractMap.SimpleEntry<String, T>(next.getKey().getKey(), next.getValue());
        }
    }

    private static class KeyIterator
    extends AbstractConverterIterator<CaseInsensitiveMapKey, String> {
        public KeyIterator(Set<CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected String convert(CaseInsensitiveMapKey next) {
            return next.getKey();
        }
    }

    private static abstract class AbstractConverterSet<A, B>
    extends AbstractSet<B> {
        private final Set<A> aSet;

        public AbstractConverterSet(Set<A> set) {
            this.aSet = set;
        }

        @Override
        public int size() {
            return this.aSet.size();
        }

        @Override
        public Iterator<B> iterator() {
            return this.createIterator(this.aSet);
        }

        protected abstract Iterator<B> createIterator(Set<A> var1);
    }

    private static class EntrySet<T>
    extends AbstractConverterSet<Map.Entry<CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntrySet(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Iterator<Map.Entry<String, T>> createIterator(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            return new EntryIterator<T>(entries);
        }
    }

    private static class KeySet
    extends AbstractConverterSet<CaseInsensitiveMapKey, String> {
        public KeySet(Set<CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected Iterator<String> createIterator(Set<CaseInsensitiveMapKey> keys) {
            return new KeyIterator(keys);
        }
    }

    private static class CaseInsensitiveMapKey
    implements Serializable {
        private final String key;
        private final String keyLowerCase;
        private final int keyHash;

        public CaseInsensitiveMapKey(Object key) {
            this.key = key.toString();
            this.keyLowerCase = this.key.toLowerCase();
            this.keyHash = this.keyLowerCase.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.keyHash;
        }

        public boolean equals(Object obj) {
            return obj instanceof CaseInsensitiveMapKey && this.keyLowerCase.equals(((CaseInsensitiveMapKey)obj).keyLowerCase);
        }
    }
}

