/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.jk.common.JkInputStream;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.WorkerEnv;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.MessageBytes;

public class MsgContext
implements ActionHook {
    private static Log log = LogFactory.getLog(MsgContext.class);
    private static Log logTime = LogFactory.getLog((String)"org.apache.jk.REQ_TIME");
    private int type;
    private Object[] notes = new Object[32];
    private JkHandler next;
    private JkChannel source;
    private JkInputStream jkIS;
    private C2BConverter c2b;
    private Request req;
    private WorkerEnv wEnv;
    private Msg[] msgs = new Msg[10];
    private int status = 0;
    private Object control;
    private long[] timers = new long[20];
    private long jkEndpointP;
    private long xEnvP;
    public static final int TIMER_RECEIVED = 0;
    public static final int TIMER_PRE_REQUEST = 1;
    public static final int TIMER_POST_REQUEST = 2;
    public static final int JK_STATUS_NEW = 0;
    public static final int JK_STATUS_HEAD = 1;
    public static final int JK_STATUS_CLOSED = 2;
    public static final int JK_STATUS_ERROR = 3;

    public MsgContext(int bsize) {
        try {
            this.c2b = new C2BConverter("iso-8859-1");
        }
        catch (IOException iex) {
            log.warn((Object)"Can't happen", (Throwable)iex);
        }
        this.jkIS = new JkInputStream(this, bsize);
    }

    public MsgContext() {
        this(8192);
    }

    public final Object getNote(int id) {
        return this.notes[id];
    }

    public final void setNote(int id, Object o) {
        this.notes[id] = o;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int i) {
        this.type = i;
    }

    public final void setLong(int i, long l) {
        this.timers[i] = l;
    }

    public final long getLong(int i) {
        return this.timers[i];
    }

    public final WorkerEnv getWorkerEnv() {
        return this.wEnv;
    }

    public final void setWorkerEnv(WorkerEnv we) {
        this.wEnv = we;
    }

    public final JkChannel getSource() {
        return this.source;
    }

    public final void setSource(JkChannel ch) {
        this.source = ch;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setStatus(int s) {
        this.status = s;
    }

    public final JkHandler getNext() {
        return this.next;
    }

    public final void setNext(JkHandler ch) {
        this.next = ch;
    }

    public final void setRequest(Request req) {
        this.req = req;
        req.setInputBuffer(this.jkIS);
        Response res = req.getResponse();
        res.setOutputBuffer(this.jkIS);
        res.setHook(this);
    }

    public final Request getRequest() {
        return this.req;
    }

    public final Msg getMsg(int i) {
        return this.msgs[i];
    }

    public final void setMsg(int i, Msg msg) {
        this.msgs[i] = msg;
    }

    public final C2BConverter getConverter() {
        return this.c2b;
    }

    public final void setConverter(C2BConverter c2b) {
        this.c2b = c2b;
    }

    public final boolean isLogTimeEnabled() {
        return logTime.isDebugEnabled();
    }

    public JkInputStream getInputStream() {
        return this.jkIS;
    }

    public byte[] getBuffer(int id) {
        if (this.msgs[id] == null) {
            return null;
        }
        return this.msgs[id].getBuffer();
    }

    public int execute() throws IOException {
        int status = this.next.invoke(this.msgs[0], this);
        return status;
    }

    public void setJniEnv(long xEnvP) {
        this.xEnvP = xEnvP;
    }

    public long getJniEnv() {
        return this.xEnvP;
    }

    public void setJniContext(long cContext) {
        this.jkEndpointP = cContext;
    }

    public long getJniContext() {
        return this.jkEndpointP;
    }

    public Object getControl() {
        return this.control;
    }

    public void setControl(Object control) {
        this.control = control;
    }

    public void action(ActionCode actionCode, Object param) {
        Request req;
        if (actionCode == ActionCode.ACTION_COMMIT) {
            Response res;
            if (log.isDebugEnabled()) {
                log.debug((Object)"COMMIT ");
            }
            if ((res = (Response)param).isCommitted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Response already committed ");
                }
            } else {
                try {
                    this.jkIS.appendHead(res);
                }
                catch (IOException iex) {
                    log.warn((Object)"Unable to send headers", (Throwable)iex);
                    this.setStatus(3);
                }
            }
        } else if (actionCode == ActionCode.ACTION_RESET) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"RESET ");
            }
        } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
            Response res;
            if (log.isDebugEnabled()) {
                log.debug((Object)"CLIENT_FLUSH ");
            }
            if (!(res = (Response)param).isCommitted()) {
                this.action(ActionCode.ACTION_COMMIT, res);
            }
            try {
                this.source.flush(null, this);
            }
            catch (IOException iex) {
                log.debug((Object)"Error during flush", (Throwable)iex);
                res.setErrorException(iex);
                this.setStatus(3);
            }
        } else if (actionCode == ActionCode.ACTION_CLOSE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CLOSE ");
            }
            Response res = (Response)param;
            if (this.getStatus() == 2 || this.getStatus() == 3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Double CLOSE - forward ? " + res.getRequest().requestURI()));
                }
                return;
            }
            if (!res.isCommitted()) {
                this.action(ActionCode.ACTION_COMMIT, param);
            }
            try {
                this.jkIS.endMessage();
            }
            catch (IOException iex) {
                log.debug((Object)"Error sending end packet", (Throwable)iex);
                this.setStatus(3);
            }
            if (this.getStatus() != 3) {
                this.setStatus(2);
            }
            if (logTime.isDebugEnabled()) {
                this.logTime(res.getRequest(), res);
            }
        } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
            Request req2 = (Request)param;
            MessageBytes certString = (MessageBytes)req2.getNote(16);
            if (certString != null && !certString.isNull()) {
                ByteChunk certData = certString.getByteChunk();
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                X509Certificate[] jsseCerts = null;
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    int i = 0;
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[1];
                        } else {
                            X509Certificate[] tmpJsseCerts = new X509Certificate[jsseCerts.length + 1];
                            System.arraycopy(jsseCerts, 0, tmpJsseCerts, 0, jsseCerts.length);
                            jsseCerts = tmpJsseCerts;
                        }
                        jsseCerts[i++] = cert;
                    }
                }
                catch (CertificateException e) {
                    log.error((Object)"Certificate convertion failed", (Throwable)e);
                    return;
                }
                req2.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            }
        } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
            Request req3 = (Request)param;
            if (req3.remoteHost().isNull()) {
                try {
                    req3.remoteHost().setString(InetAddress.getByName(req3.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unable to resolve " + req3.remoteAddr()));
                    }
                }
            }
        } else if (actionCode == ActionCode.ACTION_ACK) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"ACK ");
            }
        } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Replay ");
            }
            ByteChunk bc = (ByteChunk)param;
            this.req.setContentLength(bc.getLength());
            this.jkIS.setReplay(bc);
        } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE && (req = (Request)param).localAddr().isNull()) {
            req.localAddr().setString(req.localName().toString());
        }
    }

    private void logTime(Request req, Response res) {
        String uri = req.requestURI().toString();
        if (uri.indexOf(".gif") > 0) {
            return;
        }
        this.setLong(2, System.currentTimeMillis());
        long t1 = this.getLong(1) - this.getLong(0);
        long t2 = this.getLong(2) - this.getLong(1);
        logTime.debug((Object)("Time pre=" + t1 + "/ service=" + t2 + " " + res.getContentLength() + " " + uri));
    }

    public void recycle() {
        this.jkIS.recycle();
    }
}

