/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import java.io.Serializable;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageRequester
extends AbstractMessageRequester {
    private final VMConnector connector;

    public VMMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        QueueSession queueSession = (QueueSession)this.connector.getTransactionalResource(this.endpoint);
        Queue queue = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
        if (queue == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No queue with name " + this.endpoint.getEndpointURI().getAddress()));
            }
            return null;
        }
        MuleMessage message = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for a message on " + this.endpoint.getEndpointURI().getAddress()));
        }
        try {
            Serializable polledItem = queue.poll(timeout);
            message = polledItem instanceof MuleEvent ? ((MuleEvent)polledItem).getMessage() : (MuleMessage)polledItem;
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Failed to receive message from queue: " + this.endpoint.getEndpointURI()));
        }
        if (message != null) {
            if (message instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)message).resetAccessControl();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received: " + message));
            }
            return message;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        this.connector.getQueueProfile().configureQueue(this.getEndpoint().getMuleContext(), this.endpoint.getEndpointURI().getAddress(), this.connector.getQueueManager());
    }

    protected void doDisconnect() throws Exception {
    }
}

