/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.security;

import java.util.Properties;
import org.apache.ws.security.components.crypto.Merlin;
import org.mule.transport.ssl.api.TlsContextKeyStoreConfiguration;
import org.mule.transport.ssl.api.TlsContextTrustStoreConfiguration;

public class WSCryptoUtils {
    private static final String WS_CRYPTO_PROVIDER_KEY = "org.apache.ws.security.crypto.provider";

    public static Properties createKeyStoreProperties(TlsContextKeyStoreConfiguration keyStoreConfiguration) {
        Properties properties = new Properties();
        properties.setProperty(WS_CRYPTO_PROVIDER_KEY, Merlin.class.getCanonicalName());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", keyStoreConfiguration.getType());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", keyStoreConfiguration.getPassword());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.private.password", keyStoreConfiguration.getKeyPassword());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", keyStoreConfiguration.getAlias());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.file", keyStoreConfiguration.getPath());
        return properties;
    }

    public static Properties createTrustStoreProperties(TlsContextTrustStoreConfiguration trustStoreConfiguration) {
        Properties properties = new Properties();
        properties.setProperty(WS_CRYPTO_PROVIDER_KEY, Merlin.class.getCanonicalName());
        properties.setProperty("org.apache.ws.security.crypto.merlin.truststore.type", trustStoreConfiguration.getType());
        properties.setProperty("org.apache.ws.security.crypto.merlin.truststore.password", trustStoreConfiguration.getPassword());
        properties.setProperty("org.apache.ws.security.crypto.merlin.truststore.file", trustStoreConfiguration.getPath());
        return properties;
    }

    public static Properties createDefaultTrustStoreProperties() {
        Properties properties = new Properties();
        properties.setProperty(WS_CRYPTO_PROVIDER_KEY, Merlin.class.getCanonicalName());
        properties.setProperty("org.apache.ws.security.crypto.merlin.load.cacerts", String.valueOf(true));
        return properties;
    }
}

