/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.InputStream;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.injector.RamlUpdater;
import org.mule.module.apikit.parser.ParserWrapper;
import org.mule.module.apikit.parser.ParserWrapperV1;
import org.mule.module.apikit.parser.ParserWrapperV2;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserService {
    private static final String PARSER_V2_PROPERTY = "apikit.raml.parser.v2";
    private static final Logger logger = LoggerFactory.getLogger(ParserService.class);
    private final String ramlPath;
    private ResourceLoader resourceLoaderV2;
    private ParserWrapper parserWrapper;
    private boolean parserV2;

    public ParserService(String ramlPath, String appHome) {
        this.ramlPath = ramlPath;
        this.setupV2ResourceLoader(appHome);
        this.checkParserVersion();
        this.setupParserWrapper(ramlPath, appHome);
    }

    private void setupV2ResourceLoader(String appHome) {
        this.resourceLoaderV2 = appHome != null ? new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(appHome)}) : new DefaultResourceLoader();
    }

    public boolean isParserV2() {
        return this.parserV2;
    }

    private void checkParserVersion() {
        String property = System.getProperty(PARSER_V2_PROPERTY);
        if (property != null && Boolean.valueOf(property).booleanValue()) {
            this.parserV2 = true;
        } else {
            InputStream content = this.resourceLoaderV2.fetchResource(this.ramlPath);
            if (content != null) {
                String dump = StreamUtils.toString((InputStream)content);
                this.parserV2 = dump.startsWith("#%RAML 1.0");
            }
        }
        logger.debug("Using parser " + (this.parserV2 ? "V2" : "V1"));
    }

    private void setupParserWrapper(String ramlPath, String appHome) {
        this.parserWrapper = this.parserV2 ? new ParserWrapperV2(ramlPath, appHome) : new ParserWrapperV1(ramlPath, appHome);
    }

    public void validateRaml() {
        this.parserWrapper.validate();
    }

    public IRaml build() {
        return this.parserWrapper.build();
    }

    public RamlUpdater getRamlUpdater(IRaml api, AbstractConfiguration configuration) {
        return this.parserWrapper.getRamlUpdater(api, configuration);
    }

    public String dumpRaml(String ramlContent, IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        return this.parserWrapper.dump(ramlContent, api, oldSchemeHostPort, newSchemeHostPort);
    }

    public String dumpRaml(IRaml api, String newBaseUri) {
        return this.parserWrapper.dump(api, newBaseUri);
    }

    public String dumpRaml(IRaml api) {
        return this.parserWrapper.dump(api, null);
    }

    public void updateBaseUri(IRaml api, String baseUri) {
        this.parserWrapper.updateBaseUri(api, baseUri);
    }
}

