/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.debug;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.debug.ErrorFieldDebugInfo;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.api.debug.ObjectFieldDebugInfo;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.util.AttributeEvaluator;

@SmallTest
public class FieldDebugInfoFactoryTestCase
extends AbstractMuleTestCase {
    public static final Exception EVALUATION_EXCEPTION = new IllegalStateException("Error");
    public static final String FIELD_NAME = "foo";
    public static final String STRING_VALUE = "bar";
    private final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private final AttributeEvaluator attributeEvaluator = (AttributeEvaluator)Mockito.mock(AttributeEvaluator.class);
    private final FieldDebugInfoFactory.FieldEvaluator fieldEvaluator = (FieldDebugInfoFactory.FieldEvaluator)Mockito.mock(FieldDebugInfoFactory.FieldEvaluator.class);

    @Test
    public void createsStringFieldWithAttributeEvaluator() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveStringValue(this.event)).thenReturn((Object)STRING_VALUE);
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, String.class, STRING_VALUE, SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsBooleanFieldWithAttributeEvaluator() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveBooleanValue(this.event)).thenReturn((Object)true);
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Boolean.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Boolean.class, true, SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsIntegerFieldWithAttributeEvaluator() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveIntegerValue(this.event)).thenReturn((Object)1);
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Integer.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Integer.class, 1, SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsObjectFieldWithAttributeEvaluator() throws Exception {
        Object value = new Object();
        Mockito.when((Object)this.attributeEvaluator.resolveValue(this.event)).thenReturn(value);
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Object.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Object.class, value, SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsStringFieldWithAttributeEvaluatorError() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveStringValue(this.event)).thenThrow(new Throwable[]{EVALUATION_EXCEPTION});
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, String.class, EVALUATION_EXCEPTION, ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsBooleanFieldWithAttributeEvaluatorError() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveBooleanValue(this.event)).thenThrow(new Throwable[]{EVALUATION_EXCEPTION});
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Boolean.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Boolean.class, EVALUATION_EXCEPTION, ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsIntegerFieldWithAttributeEvaluatorError() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveIntegerValue(this.event)).thenThrow(new Throwable[]{EVALUATION_EXCEPTION});
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Integer.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Integer.class, EVALUATION_EXCEPTION, ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsObjectFieldWithAttributeEvaluatorError() throws Exception {
        Mockito.when((Object)this.attributeEvaluator.resolveValue(this.event)).thenThrow(new Throwable[]{EVALUATION_EXCEPTION});
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Object.class, (AttributeEvaluator)this.attributeEvaluator, (MuleEvent)this.event);
        this.assertCreatedFieldDebugInfo(debugInfo, Object.class, EVALUATION_EXCEPTION, ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsFieldWithFieldEvaluator() throws Exception {
        Mockito.when((Object)this.fieldEvaluator.evaluate()).thenReturn((Object)STRING_VALUE);
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (FieldDebugInfoFactory.FieldEvaluator)this.fieldEvaluator);
        this.assertCreatedFieldDebugInfo(debugInfo, String.class, STRING_VALUE, SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsFieldWithFieldEvaluatorError() throws Exception {
        Mockito.when((Object)this.fieldEvaluator.evaluate()).thenThrow(new Throwable[]{EVALUATION_EXCEPTION});
        FieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (FieldDebugInfoFactory.FieldEvaluator)this.fieldEvaluator);
        this.assertCreatedFieldDebugInfo(debugInfo, String.class, EVALUATION_EXCEPTION, ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsFieldWithValue() throws Exception {
        SimpleFieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (Object)STRING_VALUE);
        this.assertCreatedFieldDebugInfo((FieldDebugInfo<?>)debugInfo, String.class, STRING_VALUE, (Class<? extends FieldDebugInfo>)SimpleFieldDebugInfo.class);
    }

    @Test
    public void createsFieldWithError() throws Exception {
        ErrorFieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (Exception)EVALUATION_EXCEPTION);
        this.assertCreatedFieldDebugInfo((FieldDebugInfo<?>)debugInfo, String.class, EVALUATION_EXCEPTION, (Class<? extends FieldDebugInfo>)ErrorFieldDebugInfo.class);
    }

    @Test
    public void createsFieldWithObjectDebugInfo() throws Exception {
        SimpleFieldDebugInfo fieldDebugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, String.class, (Object)STRING_VALUE);
        List<SimpleFieldDebugInfo> value = Collections.singletonList(fieldDebugInfo);
        ObjectFieldDebugInfo debugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)FIELD_NAME, Map.class, value);
        this.assertCreatedFieldDebugInfo((FieldDebugInfo<?>)debugInfo, Map.class, value, (Class<? extends FieldDebugInfo>)ObjectFieldDebugInfo.class);
    }

    private void assertCreatedFieldDebugInfo(FieldDebugInfo<?> debugInfo, Class type, Object value, Class<? extends FieldDebugInfo> debugInfoClass) {
        MatcherAssert.assertThat(debugInfo, (Matcher)Matchers.instanceOf(debugInfoClass));
        MatcherAssert.assertThat(debugInfo, FieldDebugInfoMatcher.fieldLike(FIELD_NAME, type, value));
    }
}

