/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.processor.NonBlockingMessageProcessor;

public class TestNonBlockingProcessor
implements NonBlockingMessageProcessor {
    private static Executor executor = Executors.newCachedThreadPool();

    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (!event.getExchangePattern().hasResponse()) {
            return VoidMuleEvent.getInstance();
        }
        if (event.isAllowNonBlocking() && event.getReplyToHandler() != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((ThreadSafeAccess)event).resetAccessControl();
                    try {
                        event.getReplyToHandler().processReplyTo(event, null, null);
                    }
                    catch (MessagingException e) {
                        event.getReplyToHandler().processExceptionReplyTo(e, null);
                    }
                    catch (MuleException e) {
                        event.getReplyToHandler().processExceptionReplyTo(new MessagingException(event, (Throwable)e), null);
                    }
                }
            });
            return NonBlockingVoidMuleEvent.getInstance();
        }
        return event;
    }
}

