/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ListableObjectStore;
import org.mule.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleContextTestCase {
    private static final int DEFAULT_RETRIES = 4;
    private static final String TEST_DATA = "Test Data";
    private static final String PROCESSED_DATA = "Processed Data";
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent event;
    private MessageProcessor mockRoute = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ThreadingProfile mockThreadingProfile = (ThreadingProfile)Mockito.mock(ThreadingProfile.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ListableObjectStore<MuleEvent> mockObjectStore = (ListableObjectStore)Mockito.mock(ListableObjectStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((MuleMessage)Mockito.any(MuleMessage.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        this.event = SynchronousUntilSuccessfulProcessingStrategyTestCase.getTestEvent(TEST_DATA);
        RequestContext.clear();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenThreadingProfileIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile()).thenReturn((Object)this.mockThreadingProfile);
        this.createProcessingStrategy();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        this.createProcessingStrategy();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenDlqIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockRoute);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws MuleException {
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Mockito.any(MuleEvent.class))).thenThrow(new Throwable[]{new RuntimeException("expected failure")});
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.event);
            Assert.fail((String)"processing should throw exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process(this.event);
            Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)IsSame.sameInstance((Object)e.getEvent()));
        }
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws MuleException {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.event);
            Assert.fail((String)"processing should throw exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process(this.event);
            ((ExpressionFilter)Mockito.verify((Object)this.mockAlwaysTrueFailureExpressionFilter, (VerificationMode)VerificationModeFactory.times((int)5))).accept((MuleMessage)Mockito.any(MuleMessage.class));
        }
    }

    @Test
    public void successfulExecution() throws Exception {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process(this.event)).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return (MuleEvent)invocation.getArguments()[0];
            }
        });
        MuleEvent response = processingStrategy.route(this.event);
        Assert.assertThat((Object)response, (Matcher)Is.is((Object)this.event));
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute)).process(this.event);
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)IsSame.sameInstance((Object)response));
    }

    @Test
    public void retryOnOriginalEvent() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Mockito.any(MuleEvent.class))).then((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                MuleEvent argEvent = (MuleEvent)invocation.getArguments()[0];
                Assert.assertThat((Object)argEvent.getMessageAsString(), (Matcher)Is.is((Object)SynchronousUntilSuccessfulProcessingStrategyTestCase.TEST_DATA));
                argEvent.getMessage().setPayload((Object)SynchronousUntilSuccessfulProcessingStrategyTestCase.PROCESSED_DATA);
                return argEvent;
            }
        });
        try {
            processingStrategy.route(this.event);
            Assert.fail((String)"processing should throw exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process(this.event);
            ((ExpressionFilter)Mockito.verify((Object)this.mockAlwaysTrueFailureExpressionFilter, (VerificationMode)VerificationModeFactory.times((int)5))).accept((MuleMessage)Mockito.any(MuleMessage.class));
        }
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvalutaionResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate(ackExpression, this.event)).thenReturn((Object)expressionEvalutaionResult);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Mockito.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return (MuleEvent)invocation.getArguments()[0];
            }
        });
        MuleEvent response = processingStrategy.route(this.event);
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)IsEqual.equalTo((Object)expressionEvalutaionResult));
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute)).process((MuleEvent)Mockito.any(MuleEvent.class));
        ((ExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager())).evaluate(ackExpression, this.event);
    }

    @Test
    public void successfulWithNullResponseFromRoute() throws Exception {
        Mockito.when((Object)this.mockRoute.process(this.event)).thenReturn(null);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Assert.assertThat((Object)((VoidMuleEvent)processingStrategy.route(this.event)), (Matcher)Is.is((Object)VoidMuleEvent.getInstance()));
    }

    @Test
    public void successfulWithNullEventResponseFromRoute() throws Exception {
        Mockito.when((Object)this.mockRoute.process(this.event)).thenReturn((Object)VoidMuleEvent.getInstance());
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Assert.assertThat((Object)((VoidMuleEvent)processingStrategy.route(this.event)), (Matcher)Is.is((Object)VoidMuleEvent.getInstance()));
    }

    private SynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws InitialisationException {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.initialise();
        return processingStrategy;
    }
}

