/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RegExFilterTestCase
extends AbstractMuleContextTestCase {
    private static final String PATTERN = "(.*) brown fox";
    private RegExFilter regExWithValue;

    @Before
    public void setUp() throws Exception {
        this.regExWithValue = new RegExFilter("(\\w)* with the mules");
        this.regExWithValue.setMuleContext(muleContext);
    }

    @Test
    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        Assert.assertNull((Object)filter.getPattern());
        MatcherAssert.assertThat((Object)filter.accept((Object)"No tengo dinero"), (Matcher)Matchers.is((Object)false));
        filter.setPattern(PATTERN);
        MatcherAssert.assertThat((Object)filter.accept((Object)"The quick brown fox"), (Matcher)Matchers.is((Object)true));
        filter.setPattern(null);
        MatcherAssert.assertThat((Object)filter.accept((Object)"oh-oh"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRegexFilter() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick "));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"he quick brown fox"));
        filter.setPattern(PATTERN);
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)" brown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*) brown (.*)");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)PATTERN));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*)");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
    }

    @Test
    public void testNullInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertFalse((boolean)filter.accept((Object)null));
    }

    @Test
    public void testMuleMessageInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"The quick brown fox", muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testByteArrayInput() {
        System.setProperty("mule.encoding", "UTF-8");
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        byte[] bytes = "The quick brown fox".getBytes();
        Assert.assertTrue((boolean)filter.accept((Object)bytes));
    }

    @Test
    public void testCharArrayInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        char[] chars = "The quick brown fox".toCharArray();
        Assert.assertTrue((boolean)filter.accept((Object)chars));
    }

    @Test
    public void testEqualsWithSamePattern() {
        RegExFilter filter1 = new RegExFilter(PATTERN);
        RegExFilter filter2 = new RegExFilter(PATTERN);
        Assert.assertEquals((Object)filter1, (Object)filter2);
    }

    @Test
    public void testEqualsWithDifferentPattern() {
        RegExFilter filter1 = new RegExFilter("foo");
        RegExFilter filter2 = new RegExFilter("bar");
        Assert.assertFalse((boolean)filter1.equals((Object)filter2));
    }

    @Test
    public void testEqualsWithEqualPatternAndDifferentFlags() {
        RegExFilter filter1 = new RegExFilter(PATTERN, 32);
        RegExFilter filter2 = new RegExFilter(PATTERN, 2);
        Assert.assertFalse((boolean)filter1.equals((Object)filter2));
        filter1 = new RegExFilter(PATTERN, 32);
        filter2 = new RegExFilter(PATTERN, 32);
        Assert.assertEquals((Object)filter1, (Object)filter2);
    }

    @Test
    public void equalsWithNullValues() {
        RegExFilter filter = new RegExFilter();
        filter.setPattern("");
        RegExFilter filter2 = new RegExFilter();
        filter2.setPattern("");
        MatcherAssert.assertThat((Object)filter.equals((Object)filter2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void notEqualsWithDifferentValues() {
        RegExFilter filter = new RegExFilter();
        filter.setPattern("");
        filter.setValue("value");
        RegExFilter filter2 = new RegExFilter();
        filter2.setPattern("");
        filter2.setPattern("value2");
        MatcherAssert.assertThat((Object)filter.equals((Object)filter2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void matchesValueFromMelPayload() throws InitialisationException {
        this.regExWithValue.setValue("#[payload]");
        this.regExWithValue.initialise();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)"run with the mules", muleContext);
        MatcherAssert.assertThat((Object)this.regExWithValue.accept((MuleMessage)muleMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void notMatchesValueFromMelPayload() throws InitialisationException {
        this.regExWithValue.setValue("#[payload]");
        this.regExWithValue.initialise();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)"run with the zebras", muleContext);
        MatcherAssert.assertThat((Object)this.regExWithValue.accept((MuleMessage)muleMessage), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void matchesValueFromFlowVar() throws InitialisationException {
        this.regExWithValue.setValue("#[flowVars.value]");
        this.regExWithValue.initialise();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage(null, muleContext);
        muleMessage.setInvocationProperty("value", (Object)"code with the mules");
        MatcherAssert.assertThat((Object)this.regExWithValue.accept((MuleMessage)muleMessage), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchesPlainTextValue() throws InitialisationException {
        this.regExWithValue.setValue("run with the mules");
        this.regExWithValue.initialise();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage(null, muleContext);
        MatcherAssert.assertThat((Object)this.regExWithValue.accept((MuleMessage)muleMessage), (Matcher)Matchers.is((Object)true));
    }
}

