/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OutboundRouterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testAddGoodEndpoint() throws Exception {
        DummyOutboundRouter router = new DummyOutboundRouter();
        OutboundEndpoint endpoint = OutboundRouterTestCase.getTestOutboundEndpoint("test");
        router.addRoute((MessageProcessor)endpoint);
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertTrue((boolean)router.getRoutes().contains(endpoint));
    }

    @Test
    public void testSetGoodEndpoints() throws Exception {
        ArrayList<OutboundEndpoint> list = new ArrayList<OutboundEndpoint>();
        list.add(OutboundRouterTestCase.getTestOutboundEndpoint("test"));
        list.add(OutboundRouterTestCase.getTestOutboundEndpoint("test"));
        DummyOutboundRouter router = new DummyOutboundRouter();
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertEquals((long)0L, (long)router.getRoutes().size());
        router.addRoute((MessageProcessor)OutboundRouterTestCase.getTestOutboundEndpoint("test"));
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        router.setRoutes(list);
        Assert.assertNotNull((Object)router.getRoutes());
        Assert.assertEquals((long)2L, (long)router.getRoutes().size());
    }

    @Test
    public void testSetBadEndpoints() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(OutboundRouterTestCase.getTestInboundEndpoint("test"));
        list.add(OutboundRouterTestCase.getTestOutboundEndpoint("test"));
        DummyOutboundRouter router = new DummyOutboundRouter();
        try {
            router.setRoutes(list);
            Assert.fail((String)"Invalid endpoint: Expecting an exception");
        }
        catch (Exception e) {
            Assert.assertEquals(ClassCastException.class, e.getClass());
        }
    }

    @Test
    public void testSetBad2Endpoints() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(OutboundRouterTestCase.getTestOutboundEndpoint("test"));
        list.add(OutboundRouterTestCase.getTestInboundEndpoint("test"));
        DummyOutboundRouter router = new DummyOutboundRouter();
        try {
            router.setRoutes(list);
            Assert.fail((String)"Invalid endpoint: Expecting an exception");
        }
        catch (Exception e) {
            Assert.assertEquals(ClassCastException.class, e.getClass());
        }
    }

    private static class DummyOutboundRouter
    extends AbstractOutboundRouter {
        private DummyOutboundRouter() {
        }

        public boolean isMatch(MuleMessage message) throws MuleException {
            return false;
        }

        protected MuleEvent route(MuleEvent event) throws MessagingException {
            return null;
        }
    }
}

