/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.timer;

import java.util.Timer;
import java.util.TimerTask;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.timer.EventTimerTask;
import org.mule.util.timer.TimeEvent;
import org.mule.util.timer.TimeEventListener;

public class TimerTestCase
extends AbstractMuleTestCase
implements TimeEventListener {
    private volatile boolean fired;

    @Test
    public void testTimer() throws Exception {
        Timer timer = new Timer();
        EventTimerTask task = new EventTimerTask((TimeEventListener)this);
        timer.schedule((TimerTask)task, 0L, 1000L);
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)this.fired);
    }

    @Test
    public void testStopTimer() throws Exception {
        this.fired = false;
        Timer timer = new Timer();
        EventTimerTask task = new EventTimerTask((TimeEventListener)this);
        timer.schedule((TimerTask)task, 0L, 1000L);
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)this.fired);
        this.fired = false;
        task.stop();
        Thread.sleep(1500L);
        Assert.assertTrue((!this.fired ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleListeners() throws Exception {
        this.fired = false;
        Timer timer = new Timer();
        AnotherListener listener = new AnotherListener();
        EventTimerTask task = new EventTimerTask((TimeEventListener)this);
        task.addListener((TimeEventListener)listener);
        timer.schedule((TimerTask)task, 0L, 1000L);
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)this.fired);
        Assert.assertTrue((boolean)listener.wasFired());
        listener.setWasFired(false);
        this.fired = false;
        task.stop();
        Thread.sleep(1500L);
        Assert.assertTrue((!this.fired ? 1 : 0) != 0);
        Assert.assertTrue((!listener.wasFired() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveListeners() throws Exception {
        this.fired = false;
        Timer timer = new Timer();
        AnotherListener listener = new AnotherListener();
        EventTimerTask task = new EventTimerTask((TimeEventListener)this);
        task.addListener((TimeEventListener)listener);
        timer.schedule((TimerTask)task, 0L, 1000L);
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)this.fired);
        Assert.assertTrue((boolean)listener.wasFired());
        listener.setWasFired(false);
        this.fired = false;
        task.stop();
        task.removeListener((TimeEventListener)this);
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((!this.fired ? 1 : 0) != 0);
        Assert.assertTrue((boolean)listener.wasFired());
        listener.setWasFired(false);
        task.stop();
        task.removeAllListeners();
        task.start();
        Thread.sleep(1500L);
        Assert.assertTrue((!this.fired ? 1 : 0) != 0);
        Assert.assertTrue((!listener.wasFired() ? 1 : 0) != 0);
    }

    public void timeExpired(TimeEvent e) {
        Assert.assertTrue((e.getTimeExpired() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getName());
        this.fired = true;
    }

    private class AnotherListener
    implements TimeEventListener {
        private boolean wasFired;

        private AnotherListener() {
        }

        public void timeExpired(TimeEvent e) {
            this.wasFired = true;
        }

        public boolean wasFired() {
            return this.wasFired;
        }

        public void setWasFired(boolean wasFired) {
            this.wasFired = wasFired;
        }
    }
}

