/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.nodes.snakeyaml;

import org.raml.v2.internal.framework.nodes.KeyValueNodeImpl;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYBooleanNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYFloatingNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYIntegerNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYNullNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYStringNode;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SYModelWrapper {
    private boolean supportLibraries;
    private int depth;
    public static final Tag INCLUDE_TAG = new Tag("!include");

    public SYModelWrapper(boolean supportLibraries) {
        this.supportLibraries = supportLibraries;
    }

    public Node wrap(org.yaml.snakeyaml.nodes.Node node) {
        if (node.getNodeId() == NodeId.mapping) {
            return this.wrap((MappingNode)node);
        }
        if (node.getNodeId() == NodeId.sequence) {
            return this.wrap((SequenceNode)node);
        }
        if (node.getNodeId() == NodeId.scalar) {
            return this.wrap((ScalarNode)node);
        }
        throw new IllegalStateException("Invalid node type");
    }

    private SYObjectNode wrap(MappingNode mappingNode) {
        if (mappingNode.isMerged()) {
            new MappingNodeMerger().merge(mappingNode);
        }
        SYObjectNode mapping = new SYObjectNode(mappingNode);
        ++this.depth;
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            this.checkForUsesKey(nodeTuple);
            Node key = this.wrap(nodeTuple.getKeyNode());
            Node value = this.wrap(nodeTuple.getValueNode());
            KeyValueNodeImpl keyValue = new KeyValueNodeImpl(key, value);
            mapping.addChild(keyValue);
        }
        --this.depth;
        return mapping;
    }

    private void checkForUsesKey(NodeTuple nodeTuple) {
        if (!this.supportLibraries) {
            return;
        }
        if (this.depth > 1) {
            return;
        }
        if (!(nodeTuple.getKeyNode() instanceof ScalarNode) || !"uses".equals(((ScalarNode)nodeTuple.getKeyNode()).getValue())) {
            return;
        }
        if (nodeTuple.getValueNode() instanceof MappingNode) {
            for (NodeTuple libTuple : ((MappingNode)nodeTuple.getValueNode()).getValue()) {
                if (!(libTuple.getValueNode() instanceof ScalarNode)) continue;
                libTuple.getValueNode().setTag(INCLUDE_TAG);
            }
        }
    }

    private Node wrap(ScalarNode scalarNode) {
        Tag tag = scalarNode.getTag();
        if (INCLUDE_TAG.equals((Object)tag)) {
            return new SYIncludeNode(scalarNode);
        }
        if (Tag.NULL.equals((Object)tag)) {
            return new SYNullNode((org.yaml.snakeyaml.nodes.Node)scalarNode);
        }
        if (Tag.FLOAT.equals((Object)tag)) {
            return new SYFloatingNode(scalarNode);
        }
        if (Tag.INT.equals((Object)tag)) {
            SYIntegerNode syIntegerNode = new SYIntegerNode(scalarNode);
            try {
                syIntegerNode.getValue();
                return syIntegerNode;
            }
            catch (NumberFormatException e) {
                return new SYStringNode(scalarNode);
            }
        }
        String value = scalarNode.getValue();
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return new SYBooleanNode(scalarNode);
        }
        return new SYStringNode(scalarNode);
    }

    private SYArrayNode wrap(SequenceNode sequenceNode) {
        SYArrayNode sequence = new SYArrayNode(sequenceNode);
        for (org.yaml.snakeyaml.nodes.Node node : sequenceNode.getValue()) {
            sequence.addChild(this.wrap(node));
        }
        return sequence;
    }

    private static class MappingNodeMerger
    extends SafeConstructor {
        private MappingNodeMerger() {
        }

        void merge(MappingNode mappingNode) {
            this.flattenMapping(mappingNode);
        }
    }
}

