/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import com.fasterxml.jackson.core.JsonParseException;
import java.util.List;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.SchemaNodeImpl;
import org.raml.v2.internal.framework.phase.Phase;
import org.raml.v2.internal.utils.SchemaGenerator;

public class SchemaValidationPhase
implements Phase {
    SchemaGenerator schemaGenerator;

    public SchemaValidationPhase(ResourceLoader resourceLoader) {
        this.schemaGenerator = new SchemaGenerator(resourceLoader);
    }

    @Override
    public Node apply(Node tree) {
        List<SchemaNodeImpl> schemas = tree.findDescendantsWith(SchemaNodeImpl.class);
        for (SchemaNodeImpl schema : schemas) {
            try {
                if (SchemaGenerator.isXmlSchemaNode(schema)) {
                    this.schemaGenerator.generateXmlSchema(schema);
                    continue;
                }
                if (!SchemaGenerator.isJsonSchemaNode(schema)) continue;
                this.schemaGenerator.generateJsonSchema(schema);
            }
            catch (JsonParseException ex) {
                schema.replaceWith(ErrorNodeFactory.createInvalidSchemaNode(ex.getOriginalMessage()));
            }
            catch (Exception e) {
                schema.replaceWith(ErrorNodeFactory.createInvalidSchemaNode(e.getMessage()));
            }
        }
        return tree;
    }
}

