/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.v2.internal.framework.nodes.ArrayNode;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYArrayNode;

public class NodeSelector {
    public static final String PARENT_EXPR = "..";
    public static final String WILDCARD_SELECTOR = "*";
    public static final String ENCODED_SLASH = "\\\\/";

    @Nullable
    public static Node selectFrom(String path, Node from) {
        if (path.startsWith("/")) {
            return NodeSelector.selectFrom(path.substring(1), from.getRootNode());
        }
        String[] tokens = path.split("(?<!\\\\)/");
        return NodeSelector.selectFrom(Arrays.asList(tokens), from);
    }

    @Nullable
    public static Integer selectIntValue(String path, Node from) {
        return NodeSelector.selectType(path, from, null);
    }

    @Nullable
    public static String selectStringValue(String path, Node from) {
        return NodeSelector.selectType(path, from, null);
    }

    public static <T> T selectType(String path, Node from, T defaultValue) {
        SimpleTypeNode selectedNode = (SimpleTypeNode)NodeSelector.selectFrom(path, from);
        if (selectedNode != null) {
            return selectedNode.getValue();
        }
        return defaultValue;
    }

    public static List<String> selectStringCollection(String path, Node from) {
        return NodeSelector.selectCollection(path, from);
    }

    private static <T> List<T> selectCollection(String path, Node from) {
        ArrayList selectedValues = Lists.newArrayList();
        Node selectedNode = NodeSelector.selectFrom(path, from);
        if (selectedNode != null) {
            if (selectedNode instanceof SimpleTypeNode) {
                selectedValues.add(((SimpleTypeNode)selectedNode).getValue());
            } else if (selectedNode instanceof SYArrayNode) {
                for (Node node : selectedNode.getChildren()) {
                    if (!(node instanceof SimpleTypeNode)) continue;
                    selectedValues.add(((SimpleTypeNode)node).getValue());
                }
            }
        }
        return selectedValues;
    }

    @Nullable
    private static Node selectFrom(List<String> pathTokens, Node from) {
        Node currentNode = from;
        block0: for (int i = 0; i < pathTokens.size() && currentNode != null; ++i) {
            String token = pathTokens.get(i);
            if (token.equals(WILDCARD_SELECTOR)) {
                if (!(currentNode instanceof ArrayNode)) continue;
                List<Node> children = currentNode.getChildren();
                List<String> remainingTokens = pathTokens.subList(i + 1, pathTokens.size());
                for (Node child : children) {
                    Node resolve = NodeSelector.selectFrom(remainingTokens, child);
                    if (resolve == null) continue;
                    currentNode = resolve;
                    break block0;
                }
                break;
            }
            if (token.equals(PARENT_EXPR)) {
                currentNode = currentNode.getParent();
                continue;
            }
            if (currentNode instanceof ObjectNode) {
                currentNode = NodeSelector.findValueWithName(currentNode, token);
                continue;
            }
            if (currentNode instanceof ArrayNode) {
                int index = Integer.parseInt(token);
                currentNode = NodeSelector.findElementAtIndex(currentNode, index);
                continue;
            }
            currentNode = null;
        }
        return currentNode;
    }

    @Nullable
    private static Node findElementAtIndex(Node currentNode, int index) {
        Node result = null;
        List<Node> children = currentNode.getChildren();
        if (children.size() > index) {
            result = children.get(index);
        }
        return result;
    }

    @Nullable
    private static Node findValueWithName(Node currentNode, String token) {
        Node result = null;
        List<Node> children = currentNode.getChildren();
        for (Node child : children) {
            Node key;
            if (!(child instanceof KeyValueNode) || !((key = ((KeyValueNode)child).getKey()) instanceof SimpleTypeNode) || !token.equals(NodeSelector.encodePath(String.valueOf(((SimpleTypeNode)key).getValue())))) continue;
            result = ((KeyValueNode)child).getValue();
            break;
        }
        return result;
    }

    public static String encodePath(String path) {
        return path.replaceAll("/", ENCODED_SLASH);
    }
}

