/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.statement;

import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.util.Preconditions;

public class QueryStatementFactory
implements ConfigurableStatementFactory {
    private int maxRows;
    private Integer fetchSize;
    private int queryTimeout = 0;

    @Override
    public Statement create(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        return this.create(connection, queryTemplate, new NoAutoGeneratedKeyStrategy());
    }

    @Override
    public Statement create(DbConnection connection, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        Statement result;
        if (queryTemplate.getType().equals((Object)QueryType.STORE_PROCEDURE_CALL)) {
            result = connection.prepareCall(queryTemplate.getSqlText(), 1003, 1007);
        } else {
            boolean hasInputParams = queryTemplate.getInputParams().size() > 0;
            result = hasInputParams ? autoGeneratedKeyStrategy.prepareStatement(connection, queryTemplate) : connection.createStatement();
        }
        if (this.maxRows > 0) {
            result.setMaxRows(this.maxRows);
        }
        if (this.fetchSize != null) {
            result.setFetchSize(this.fetchSize);
        }
        if (this.queryTimeout != 0) {
            result.setQueryTimeout(this.queryTimeout);
        }
        return result;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }

    @Override
    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        Preconditions.checkArgument((queryTimeout >= 0 ? 1 : 0) != 0, (String)"Query timeout must be positive");
        this.queryTimeout = queryTimeout;
    }
}

