/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class FinishesEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator FINISHES = Operator.addOperatorToRegistry("finishes", false);
    public static final Operator FINISHES_NOT = Operator.addOperatorToRegistry("finishes", true);
    private static final String[] SUPPORTED_IDS = new String[]{FINISHES.getOperatorString()};
    private Map<String, FinishesEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        FinishesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, FinishesEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new FinishesEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class FinishesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 6232789044144077522L;
        private long endDev;
        private String paramText;

        public FinishesEvaluator() {
        }

        public FinishesEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? FINISHES_NOT : FINISHES);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        public Object prepareLeftObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'finishes' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long distStart = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp() - ((EventFactHandle)left).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)left).getEndTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long distStart = ((EventFactHandle)right).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp() - ((EventFactHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long distStart = ((EventFactHandle)object1).getStartTimestamp() - ((EventFactHandle)object2).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)object2).getEndTimestamp() - ((EventFactHandle)object1).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public String toString() {
            return "finishes[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinishesEvaluator other = (FinishesEvaluator)obj;
            return this.endDev == other.endDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.endDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeDroolsException("[Finishes Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeDroolsException("[Finishes Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.endDev = parameters[0];
            }
        }
    }
}

