<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math"
    xmlns:doc="http://www.saxonica.com/ns/doc" xmlns:f="MyFunctions"
    exclude-result-prefixes="xs math" version="3.0">

    <doc:synopsis title="Stats log preprocessing">
        <p>Preprocess a statistics log file</p>
    </doc:synopsis>
    <xsl:output method="xml" indent="yes"/>
    <xsl:mode name="process.stats" on-no-match="shallow-copy"
        doc:doc="The reserved mode for preprocessing"/>



    <xsl:template match="statsRTL" mode="process.stats">
        <stats>
            <xsl:sequence select="@*"/>
            <xsl:attribute name="total.invocations" select="sum(mode/rule/@count)"/>
            <xsl:attribute name="total.time" select="sum(mode/rule/@total)"/>
            <xsl:sequence select="config"/>
            <xsl:for-each select="mode">
                <xsl:copy>
                    <xsl:sequence select="@*"/>
                    <xsl:attribute name="total.invocations" select="sum(rule/@count)"/>
                    <xsl:attribute name="total.time" select="sum(rule/@total)"/>
                    <xsl:variable name="stats" select="*"/>
                    <xsl:for-each-group select="$stats" group-by="@loc">
                        <xsl:variable name="total.time" select="sum(current-group()/@total)"/>
                        <xsl:variable name="invocations" select="sum(@count)"/>
                        <rule loc="{current-grouping-key()}" invocations="{$invocations}"
                            mode="{f:modeName((@mode,'#default')[1])}">
                            <xsl:sequence
                                select="
                                    @calls,
                                    @seq,
                                    @rank"/>
                            <xsl:attribute name="times.total" select="@total"/>
                            <xsl:attribute name="times.min" select="@min"/>
                            <xsl:attribute name="times.avg" select="@avg"/>
                            <xsl:attribute name="times.max" select="@max"/>
                        </rule>
                    </xsl:for-each-group>
                </xsl:copy>
            </xsl:for-each>
        </stats>

    </xsl:template>

    <xsl:function name="f:stats" as="attribute()*">
        <xsl:param name="times" as="xs:double*"/>
        <xsl:variable name="outlier.multiplier" select="10"/>
        <xsl:variable name="all.min" select="min($times)"/>
        <xsl:variable name="outlier.threshold"
            select="
                if ($all.min eq 0) then
                    max($times)
                else
                    $outlier.multiplier * $all.min"/>
        <xsl:variable name="outliers" select="$times[. gt $outlier.threshold]"/>
        <xsl:variable name="outlier.threshold"
            select="
                if (count($outliers) gt 20) then
                    max($times)
                else
                    $outlier.threshold"/>
        <xsl:variable name="outliers" select="$times[. gt $outlier.threshold]"/>
        <xsl:if test="exists($outliers)">
            <xsl:attribute name="time.outliers" select="$outliers"/>
        </xsl:if>
        <xsl:variable name="times.used" select="$times[. le $outlier.threshold]"/>
        <xsl:variable name="sorted" as="xs:double*">
            <xsl:perform-sort select="$times.used">
                <xsl:sort select="."/>
            </xsl:perform-sort>
        </xsl:variable>
        <xsl:if test="count($sorted) gt 10">
            <xsl:attribute name="times.lower4" select="$sorted[xs:integer(0.25 * count($sorted))]"/>
            <xsl:attribute name="times.upper4" select="$sorted[xs:integer(0.75 * count($sorted))]"/>
        </xsl:if>
        <xsl:attribute name="times.total" select="xs:integer(sum($times.used))"/>
        <xsl:attribute name="times.min" select="xs:integer(min($times.used))"/>
        <xsl:attribute name="times.avg" select="xs:integer(avg($times.used))"/>
        <xsl:attribute name="times.max" select="xs:integer(max($times.used))"/>
    </xsl:function>

    <xsl:function name="f:modeName" as="xs:string" doc:doc="produce a name from a mode name">
        <xsl:param name="mode" as="xs:string"/>
        <xsl:value-of
            select="
                if ($mode = 'saxon:_defaultMode') then
                    '#default'
                else
                    $mode"
        />
    </xsl:function>
</xsl:stylesheet>
